/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine;

import org.thymeleaf.testing.templateengine.context.IProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.context.web.JakartaServletTestWebExchangeBuilder;
import org.thymeleaf.testing.templateengine.context.web.JavaxServletTestWebExchangeBuilder;
import org.thymeleaf.testing.templateengine.context.web.WebProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.report.ITestReporter;
import org.thymeleaf.testing.templateengine.report.MinimalConsoleTestReporter;

public final class TestExecutorFactory {
    private static final ITestReporter MINIMAL_TEST_REPORTER = new MinimalConsoleTestReporter();

    public static TestExecutor createTestExecutor(String name, IProcessingContextBuilder processingContextBuilder) {
        TestExecutor testExecutor = new TestExecutor(name, processingContextBuilder);
        testExecutor.setReporter(MINIMAL_TEST_REPORTER);
        return testExecutor;
    }

    public static TestExecutor createTestExecutor(IProcessingContextBuilder processingContextBuilder) {
        return TestExecutorFactory.createTestExecutor("default", processingContextBuilder);
    }

    public static TestExecutor createJakartaWebTestExecutor() {
        return TestExecutorFactory.createTestExecutor("jakarta", new WebProcessingContextBuilder(JakartaServletTestWebExchangeBuilder.create()));
    }

    public static TestExecutor createJavaxWebTestExecutor() {
        return TestExecutorFactory.createTestExecutor("javax", new WebProcessingContextBuilder(JavaxServletTestWebExchangeBuilder.create()));
    }

    private TestExecutorFactory() {
    }
}

