/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.cache;

import java.util.Set;
import org.thymeleaf.cache.ExpressionCacheKey;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheEntryValidityChecker;
import org.thymeleaf.cache.TemplateCacheKey;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;

public final class TestCache<K, V>
implements ICache<K, V> {
    private final ICache<K, V> cache;

    public TestCache(ICache<K, V> cache) {
        this.cache = cache;
    }

    private Object prefix(K key) {
        String testName = TestExecutor.getThreadTestName();
        if (key instanceof String) {
            return testName + "_" + key;
        }
        if (key instanceof TemplateCacheKey) {
            TemplateCacheKey cacheKey = (TemplateCacheKey)key;
            return new TemplateCacheKey(cacheKey.getOwnerTemplate(), testName + "_" + cacheKey.getTemplate(), cacheKey.getTemplateSelectors(), cacheKey.getLineOffset(), cacheKey.getColOffset(), cacheKey.getTemplateMode(), cacheKey.getTemplateResolutionAttributes());
        }
        if (key instanceof ExpressionCacheKey) {
            ExpressionCacheKey cacheKey = (ExpressionCacheKey)key;
            return new ExpressionCacheKey(testName + "_" + cacheKey.getType(), cacheKey.getExpression0(), cacheKey.getExpression1());
        }
        return key;
    }

    public void put(K key, V value) {
        this.cache.put(this.prefix(key), value);
    }

    public V get(K key) {
        return (V)this.cache.get(this.prefix(key));
    }

    public V get(K key, ICacheEntryValidityChecker<? super K, ? super V> validityChecker) {
        return (V)this.cache.get(this.prefix(key), validityChecker);
    }

    public void clear() {
        this.cache.clear();
    }

    public void clearKey(K key) {
        this.cache.clearKey(this.prefix(key));
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }
}

