/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.util;

import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.extras.springsecurity6.util.SpringVersionSpecificUtils;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.servlet.IServletWebApplication;
import org.thymeleaf.web.servlet.IServletWebExchange;

public final class SpringSecurityContextUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringSecurityContextUtils.class);
    public static final String SECURITY_CONTEXT_MODEL_ATTRIBUTE_NAME = "thymeleafSpringSecurityContext";

    private SpringSecurityContextUtils() {
    }

    public static ApplicationContext getApplicationContext(IContext context) {
        if (SpringVersionSpecificUtils.isWebMvcContext(context)) {
            return SpringSecurityWebMvcApplicationContextUtils.findRequiredWebApplicationContext(context);
        }
        if (SpringVersionSpecificUtils.isWebFluxContext(context)) {
            return SpringSecurityWebFluxApplicationContextUtils.findRequiredApplicationContext(context);
        }
        throw new IllegalStateException("No ApplicationContext found for Spring Security: Thymeleaf context is neither an implementation of IWebContext (for Spring MVC apps) nor ISpringWebFluxContext (for Spring WebFlux apps). Thymeleaf's Spring Security support can only be used in web applications.");
    }

    public static Object getRequestAttribute(IContext context, String attributeName) {
        if (SpringVersionSpecificUtils.isWebMvcContext(context)) {
            return SpringSecurityWebMvcApplicationContextUtils.getRequestAttribute(context, attributeName);
        }
        if (SpringVersionSpecificUtils.isWebFluxContext(context)) {
            return SpringSecurityWebFluxApplicationContextUtils.getRequestAttribute(context, attributeName);
        }
        throw new IllegalStateException("Could not obtain request attributes: Thymeleaf context is neither an implementation of IWebContext (for Spring MVC apps) nor ISpringWebFluxContext (for Spring WebFlux apps). Thymeleaf's Spring Security support can only be used in web applications.");
    }

    public static String getContextPath(IContext context) {
        if (SpringVersionSpecificUtils.isWebMvcContext(context)) {
            return SpringSecurityWebMvcApplicationContextUtils.getContextPath(context);
        }
        if (SpringVersionSpecificUtils.isWebFluxContext(context)) {
            return SpringSecurityWebFluxApplicationContextUtils.getContextPath(context);
        }
        throw new IllegalStateException("Could not obtain context path: Thymeleaf context is neither an implementation of IWebContext (for Spring MVC apps) nor ISpringWebFluxContext (for Spring WebFlux apps). Thymeleaf's Spring Security support can only be used in web applications.");
    }

    public static Authentication getAuthenticationObject(IContext context) {
        if (SpringVersionSpecificUtils.isWebMvcContext(context)) {
            return SpringSecurityWebMvcApplicationContextUtils.getAuthenticationObject();
        }
        if (SpringVersionSpecificUtils.isWebFluxContext(context)) {
            return SpringSecurityWebFluxApplicationContextUtils.getAuthenticationObject(context);
        }
        throw new IllegalStateException("Could not obtain authentication object: Thymeleaf context is neither an implementation of IWebContext (for Spring MVC apps) nor ISpringWebFluxContext (for Spring WebFlux apps). Thymeleaf's Spring Security support can only be used in web applications.");
    }

    private static final class SpringSecurityWebMvcApplicationContextUtils {
        private SpringSecurityWebMvcApplicationContextUtils() {
        }

        static Object getRequestAttribute(IContext context, String attributeName) {
            return ((IWebContext)context).getExchange().getAttributeValue(attributeName);
        }

        static String getContextPath(IContext context) {
            WebEngineContext webEngineContext = (WebEngineContext)context;
            IWebExchange webExchange = webEngineContext.getExchange();
            IServletWebExchange servletWebExchange = (IServletWebExchange)webExchange;
            return servletWebExchange.getRequest().getContextPath();
        }

        static ApplicationContext findRequiredWebApplicationContext(IContext context) {
            IServletWebApplication application = (IServletWebApplication)((IWebContext)context).getExchange().getApplication();
            ServletContext servletContext = (ServletContext)application.getNativeServletContextObject();
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            if (wac == null) {
                Enumeration attrNames = servletContext.getAttributeNames();
                while (attrNames.hasMoreElements()) {
                    String attrName = (String)attrNames.nextElement();
                    Object attrValue = servletContext.getAttribute(attrName);
                    if (!(attrValue instanceof WebApplicationContext)) continue;
                    if (wac != null) {
                        throw new IllegalStateException("No unique WebApplicationContext found: more than one DispatcherServlet registered with publishContext=true?");
                    }
                    wac = (WebApplicationContext)attrValue;
                }
            }
            if (wac == null) {
                throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
            }
            return wac;
        }

        static Authentication getAuthenticationObject() {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (securityContext == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][{}] No security context found, no authentication object returned.", new Object[]{TemplateEngine.threadIndex()});
                }
                return null;
            }
            return securityContext.getAuthentication();
        }
    }

    private static final class SpringSecurityWebFluxApplicationContextUtils {
        private SpringSecurityWebFluxApplicationContextUtils() {
        }

        static Object getRequestAttribute(IContext context, String attributeName) {
            ServerWebExchange exchange = SpringVersionSpecificUtils.getServerWebExchange(context);
            return exchange.getAttribute(attributeName);
        }

        static String getContextPath(IContext context) {
            ServerWebExchange exchange = SpringVersionSpecificUtils.getServerWebExchange(context);
            return exchange.getRequest().getPath().contextPath().value();
        }

        static ApplicationContext findRequiredApplicationContext(IContext context) {
            ServerWebExchange exchange = SpringVersionSpecificUtils.getServerWebExchange(context);
            ApplicationContext applicationContext = exchange.getApplicationContext();
            if (applicationContext == null) {
                throw new IllegalStateException("No ApplicationContext found in context for WebFlux application");
            }
            return applicationContext;
        }

        static Authentication getAuthenticationObject(IContext context) {
            SecurityContext securityContext = (SecurityContext)context.getVariable(SpringSecurityContextUtils.SECURITY_CONTEXT_MODEL_ATTRIBUTE_NAME);
            if (securityContext == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][{}] No security context found, no authentication object returned.", new Object[]{TemplateEngine.threadIndex()});
                }
                return null;
            }
            return securityContext.getAuthentication();
        }
    }
}

