/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.util;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class SpringSecurityWebApplicationContextUtils {
    private SpringSecurityWebApplicationContextUtils() {
    }

    public static WebApplicationContext findRequiredWebApplicationContext(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (wac == null) {
            Enumeration attrNames = servletContext.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                Object attrValue = servletContext.getAttribute(attrName);
                if (!(attrValue instanceof WebApplicationContext)) continue;
                if (wac != null) {
                    throw new IllegalStateException("No unique WebApplicationContext found: more than one DispatcherServlet registered with publishContext=true?");
                }
                wac = (WebApplicationContext)attrValue;
            }
        }
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }
}

