/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.auth;

import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;
import org.thymeleaf.extras.springsecurity3.auth.AclAuthUtils;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.util.Validate;

public final class AclAuthorization {
    private final Authentication authentication;
    private final ServletContext servletContext;

    public AclAuthorization(Authentication authentication, ServletContext servletContext) {
        this.authentication = authentication;
        this.servletContext = servletContext;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean acl(Object domainObject, String permissions) {
        Validate.notEmpty((String)permissions, (String)"permissions cannot be null or empty");
        ApplicationContext applicationContext = AuthUtils.getContext(this.servletContext);
        List<Permission> permissionsList = AclAuthUtils.parsePermissionsString(applicationContext, permissions);
        return AclAuthUtils.authorizeUsingAccessControlList(domainObject, permissionsList, this.authentication, this.servletContext);
    }
}

