/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.struct;

import java.nio.ByteOrder;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Packer.class);

    protected static byte[] packRaw_16b(short val, ByteOrder byteOrder) {
        byte[] bx = new byte[]{(byte)(val & 0xFF), (byte)(val >>> 8 & 0xFF)};
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ArrayUtils.reverse((byte[])bx);
        }
        return bx;
    }

    protected static byte[] packRaw_u16b(int val, ByteOrder byteOrder) {
        byte[] bx = new byte[]{(byte)(val & 0xFF), (byte)(val >>> 8 & 0xFF)};
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ArrayUtils.reverse((byte[])bx);
        }
        return bx;
    }

    protected static byte[] packRaw_32b(int val, ByteOrder byteOrder) {
        byte[] bx = new byte[]{(byte)(val & 0xFF), (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ArrayUtils.reverse((byte[])bx);
        }
        return bx;
    }

    protected static byte[] packRaw_64b(long val, ByteOrder byteOrder) {
        byte[] bx = new byte[]{(byte)(val & 0xFFL), (byte)(val >>> 8 & 0xFFL), (byte)(val >>> 16 & 0xFFL), (byte)(val >>> 24 & 0xFFL), (byte)(val >>> 32 & 0xFFL), (byte)(val >>> 40 & 0xFFL), (byte)(val >>> 48 & 0xFFL), (byte)(val >>> 56 & 0xFFL)};
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ArrayUtils.reverse((byte[])bx);
        }
        return bx;
    }

    protected static byte[] packFloat_64b(double val, ByteOrder byteOrder) {
        long bits = Double.doubleToLongBits(val);
        byte[] bytes = Packer.packRaw_64b(bits, byteOrder);
        return bytes;
    }

    protected static byte[] packRaw_u32b(long val, ByteOrder byteOrder) {
        byte[] bx = new byte[4];
        if ((val &= 0xFFFFFFFFFFFFFFFFL) >= 0L) {
            bx[0] = (byte)(val & 0xFFL);
            bx[1] = (byte)(val >> 8 & 0xFFL);
            bx[2] = (byte)(val >> 16 & 0xFFL);
            bx[3] = (byte)(val >> 24 & 0xFFL);
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ArrayUtils.reverse((byte[])bx);
        }
        return bx;
    }

    protected static short unpackRaw_16b(byte[] val, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])val);
        }
        int x = (val[0] & 0xFF) << 8 | val[1] & 0xFF;
        return (short)x;
    }

    protected static int unpackRaw_u16b(byte[] val, ByteOrder byteOrder) {
        LOGGER.info("unpackRaw_u16b: {}", (Object)val);
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])val);
        }
        int x = (val[0] & 0xFF) << 8 | val[1] & 0xFF;
        return x;
    }

    protected static int unpackRaw_32b(byte[] val, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])val);
        }
        int x = (val[0] & 0xFF) << 24 | (val[1] & 0xFF) << 16 | (val[2] & 0xFF) << 8 | val[3] & 0xFF;
        return x;
    }

    protected static long unpackRaw_u32b(byte[] val, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])val);
        }
        long x = (long)(val[0] & 0xFF) << 24 | (long)(val[1] & 0xFF) << 16 | (long)(val[2] & 0xFF) << 8 | (long)(val[3] & 0xFF);
        return x;
    }

    protected static long unpackRaw_64b(byte[] val, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])val);
        }
        long x = (long)(val[0] & 0xFF) << 56 | (long)(val[1] & 0xFF) << 48 | (long)(val[2] & 0xFF) << 40 | (long)(val[3] & 0xFF) << 32 | (long)(val[4] & 0xFF) << 24 | (long)(val[5] & 0xFF) << 16 | (long)(val[6] & 0xFF) << 8 | (long)(val[7] & 0xFF);
        return x;
    }

    protected static double unpackFloat_64b(byte[] val, ByteOrder byteOrder) {
        long x = Packer.unpackRaw_64b(val, byteOrder);
        double d = Double.longBitsToDouble(x);
        return d;
    }
}

