/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.struct;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thshsh.struct.MappingException;
import org.thshsh.struct.StructEntityMapping;
import org.thshsh.struct.StructToken;
import org.thshsh.struct.StructTokenPrefix;
import org.thshsh.struct.StructTokenSuffix;
import org.thshsh.struct.Token;
import org.thshsh.struct.TokenType;

public class Mapping {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Mapping.class);
    protected PropertyDescriptor property;
    protected Field field;
    protected StructToken annotation;
    protected StructTokenPrefix prefix;
    protected StructTokenSuffix suffix;
    List<Token> prefixTokens;
    Token token;
    List<Token> suffixTokens;
    protected Class<?> type;
    protected Object constantValue;
    protected TokenType tokenType;
    protected Integer length;

    public Mapping(PropertyDescriptor property, Field f, StructToken annotation, StructTokenPrefix pre, StructTokenSuffix suf, Class<?> type) {
        Token t;
        this.field = f;
        this.property = property;
        this.annotation = annotation;
        this.type = type;
        this.tokenType = annotation.type() != TokenType.Auto ? annotation.type() : TokenType.fromClass(type, false);
        this.prefix = pre;
        this.suffix = suf;
        this.prefixTokens = new ArrayList<Token>();
        this.suffixTokens = new ArrayList<Token>();
        this.length = 0;
        if (StringUtils.isNotEmpty((CharSequence)annotation.constant())) {
            if (this.tokenType.convert == null) {
                throw new MappingException("Cannot specify constants for TokenType " + (Object)((Object)this.tokenType));
            }
            this.constantValue = this.tokenType.convert(annotation.constant());
        }
        if (this.prefix != null) {
            for (StructToken token : this.prefix.value()) {
                t = StructEntityMapping.annotationToToken(token);
                if (t.constant == null) {
                    throw new MappingException("StructToken prefix/suffix must specify a constant");
                }
                t.hide = true;
                this.prefixTokens.add(t);
                this.length = this.length + t.byteCount();
            }
        }
        StructToken st = annotation;
        TokenType tt = this.tokenType;
        Token t2 = StructEntityMapping.annotationToToken(st, tt);
        this.length = this.length + t2.byteCount();
        this.token = t2;
        if (this.suffix != null) {
            for (StructToken token : this.suffix.value()) {
                t = StructEntityMapping.annotationToToken(token);
                if (t.constant == null) {
                    throw new MappingException("StructToken prefix/suffix must specify a constant");
                }
                t.hide = true;
                this.length = this.length + t.byteCount();
                this.suffixTokens.add(t);
            }
        }
    }

    public void addPrefixBytes(int count) {
        Token t = new Token(TokenType.Bytes, count);
        t.hide = true;
        this.length = this.length + count;
        this.prefixTokens.add(t);
    }

    public void setValue(Object instance, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.property != null) {
            PropertyUtils.setSimpleProperty((Object)instance, (String)this.property.getName(), (Object)value);
        } else {
            this.field.set(instance, value);
        }
    }

    public Object getValue(Object o) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.isConstant()) {
            return this.constantValue;
        }
        if (this.property != null) {
            return PropertyUtils.getSimpleProperty((Object)o, (String)this.property.getName());
        }
        return this.field.get(o);
    }

    public boolean isConstant() {
        return this.constantValue != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[property=");
        builder.append(this.property);
        builder.append(", field=");
        builder.append(this.field);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", tokenType=");
        builder.append((Object)this.tokenType);
        builder.append(", length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }
}

