/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.python.PythonFileNameAndRelativeName;
import org.testingisdocumenting.znai.python.PythonIncludePluginBase;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.PythonIncludeResultBuilder;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonParsedFile;
import org.testingisdocumenting.znai.python.PythonUtils;

public class PythonMethodIncludePlugin
extends PythonIncludePluginBase {
    private PythonFileNameAndRelativeName fileAndRelativeEntryName;

    public String id() {
        return "python-method";
    }

    public IncludePlugin create() {
        return new PythonMethodIncludePlugin();
    }

    @Override
    protected String snippetIdToUse() {
        return this.pluginParams.getFreeParam();
    }

    @Override
    protected String fileNameToUse() {
        this.fileAndRelativeEntryName = PythonUtils.findFileNameAndRelativeNameByFullyQualifiedName(this.resourcesResolver, this.pluginParams.getFreeParam());
        return this.fileAndRelativeEntryName.getFileName();
    }

    @Override
    protected String defaultPackageName() {
        return this.fileAndRelativeEntryName.getPackageName();
    }

    @Override
    public PythonIncludeResult process(PythonParsedFile parsed, ParserHandler parserHandler, Path markupPath) {
        PythonParsedEntry funcEntry = parsed.findRequiredEntryByTypeAndName("function", this.fileAndRelativeEntryName.getRelativeName());
        String fullyQualifiedName = this.pluginParams.getFreeParam();
        PythonIncludeResultBuilder builder = new PythonIncludeResultBuilder(this.componentsRegistry, parserHandler, markupPath, fullyQualifiedName);
        PythonIncludeResultBuilder.MarginOpts marginOpts = funcEntry.getDocString().isEmpty() ? PythonIncludeResultBuilder.MarginOpts.DEFAULT : PythonIncludeResultBuilder.MarginOpts.EXTRA_BOTTOM_MARGIN;
        builder.addMethodSignature(this.fileAndRelativeEntryName.getPackageName(), funcEntry, PythonIncludeResultBuilder.NameRenderOpt.FULL_NAME, PythonIncludeResultBuilder.ArgsRenderOpt.KEEP_SELF, marginOpts, true);
        builder.addPyDocTextOnly(funcEntry);
        builder.addPyDocParams(this.fileAndRelativeEntryName.getPackageName(), funcEntry);
        return builder.build();
    }
}

