/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonType;
import org.testingisdocumenting.znai.structure.DocStructure;

public class PythonArg {
    private final Category category;
    private final String name;
    private final PythonType type;
    private final String defaultValue;

    public PythonArg(Map<String, Object> parsed, PythonContext context) {
        this.category = this.extractCategory(parsed.get("category").toString());
        this.name = parsed.get("name").toString();
        this.type = new PythonType(parsed.get("type"), context);
        this.defaultValue = parsed.containsKey("defaultValue") ? parsed.get("defaultValue").toString() : "";
    }

    public String getName() {
        return this.name;
    }

    public PythonType getType() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "PythonCodeArg{category=" + this.category + ", name='" + this.name + "', type=" + this.type + ", defaultValue='" + this.defaultValue + "'}";
    }

    public Map<String, ?> toMap(DocStructure docStructure) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("category", this.category.name());
        map.put("name", this.name);
        map.put("defaultValue", this.defaultValue);
        map.put("type", this.type.convertToApiLinkedText(docStructure).toListOfMaps());
        return map;
    }

    private Category extractCategory(String category) {
        switch (category) {
            case "args": {
                return Category.ARGS;
            }
            case "kwargs": {
                return Category.KWARGS;
            }
            case "pos_only": {
                return Category.POS_ONLY;
            }
            case "kw_only": {
                return Category.KW_ONLY;
            }
        }
        return Category.REGULAR;
    }

    static enum Category {
        REGULAR,
        POS_ONLY,
        KW_ONLY,
        ARGS,
        KWARGS;

    }
}

