/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.file.ManipulatedSnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetsCommon;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.JavaCodeUtils;
import org.testingisdocumenting.znai.java.parser.JavaMethod;
import org.testingisdocumenting.znai.java.parser.JavaType;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.utils.EntriesSeparatorUtils;
import org.testingisdocumenting.znai.utils.StringUtils;

public class JavaIncludePlugin
extends JavaIncludePluginBase {
    private static final String BODY_ONLY_KEY = "bodyOnly";
    private static final String SIGNATURE_ONLY_KEY = "signatureOnly";
    private static final String ENTRY_SEPARATOR_KEY = "entrySeparator";
    private static final String REMOVE_RETURN_KEY = "removeReturn";
    private static final String REMOVE_SEMICOLON_KEY = "removeSemicolon";
    private PluginParamsOpts opts;
    private boolean isBodyOnly;
    private boolean isSignatureOnly;
    private String entrySeparator;

    public String id() {
        return "java";
    }

    public IncludePlugin create() {
        return new JavaIncludePlugin();
    }

    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add("entry", PluginParamType.LIST_OR_SINGLE_STRING, "entry to include content of", "\"myMethod\" or [\"myMethod1(String)\", \"myMethod2(Integer)\"]").add(ENTRY_SEPARATOR_KEY, PluginParamType.STRING, "separator to use when displaying multiple entries", "\"...\"").add(BODY_ONLY_KEY, PluginParamType.BOOLEAN, "renders content of an entry, omitting signature", "true").add(SIGNATURE_ONLY_KEY, PluginParamType.BOOLEAN, "renders only signature of an entry", "true").add(REMOVE_RETURN_KEY, PluginParamType.BOOLEAN, "remove <return> from a method content", "true").add(REMOVE_SEMICOLON_KEY, PluginParamType.BOOLEAN, "remove semicolon \";\" from a method content", "true").add(SnippetsCommon.createParamsDefinition());
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        this.opts = this.pluginParams.getOpts();
        this.isBodyOnly = (Boolean)this.opts.get(BODY_ONLY_KEY, (Object)false);
        this.isSignatureOnly = (Boolean)this.opts.get(SIGNATURE_ONLY_KEY, (Object)false);
        this.entrySeparator = (String)this.opts.get(ENTRY_SEPARATOR_KEY);
        if (this.isBodyOnly && this.isSignatureOnly) {
            throw new IllegalArgumentException("specify only bodyOnly or signatureOnly");
        }
        ManipulatedSnippetContentProvider contentProvider = new ManipulatedSnippetContentProvider(this.path, this.extractContent(javaCode), this.pluginParams);
        this.features.add(SnippetsCommon.createCommonFeatures((ComponentsRegistry)this.componentsRegistry, (Path)this.markupPath, (PluginParams)this.pluginParams, (SnippetContentProvider)contentProvider).asList());
        Map props = CodeSnippetsProps.create((String)"java", (String)contentProvider.snippetContent());
        props.putAll(this.pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        DocElement docElement = new DocElement("Snippet");
        docElement.addProps(props);
        return new JavaIncludeResult(Collections.singletonList(docElement), contentProvider.snippetContent());
    }

    private String extractContent(JavaCode javaCode) {
        if (this.entries.isEmpty()) {
            return javaCode.getFileContent();
        }
        return this.entries.stream().map(nameWithOptionalType -> this.extractEntryContent(javaCode, (String)nameWithOptionalType)).collect(this.collectorWithSeparator());
    }

    private String extractEntryContent(JavaCode javaCode, String entry) {
        return javaCode.hasType(entry) ? this.extractTypeContent(javaCode, entry) : this.extractMethodContent(javaCode, entry);
    }

    private String extractTypeContent(JavaCode javaCode, String entry) {
        JavaType type = javaCode.findType(entry);
        return this.isBodyOnly ? type.getBodyOnly() : type.getFullBody();
    }

    private String extractMethodContent(JavaCode javaCode, String entry) {
        if (this.isBodyOnly) {
            return this.extractBodiesOnly(Collections.singletonList(javaCode.findMethod(entry)));
        }
        List<JavaMethod> allMethods = javaCode.findAllMethods(entry);
        if (this.isSignatureOnly) {
            return this.extractSignaturesOnly(allMethods);
        }
        return this.extractFullBodies(allMethods);
    }

    private String extractFullBodies(List<JavaMethod> methods) {
        return methods.stream().map(JavaMethod::getFullBody).collect(this.collectorWithSeparator());
    }

    private String extractBodiesOnly(List<JavaMethod> methods) {
        return methods.stream().map(this::extractBodyOnly).collect(this.collectorWithSeparator());
    }

    private String extractSignaturesOnly(List<JavaMethod> methods) {
        return methods.stream().map(JavaMethod::getSignatureOnly).collect(this.collectorWithSeparator());
    }

    private String extractBodyOnly(JavaMethod method) {
        String result = method.getBodyOnly();
        boolean removeReturn = (Boolean)this.opts.get(REMOVE_RETURN_KEY, (Object)false);
        result = removeReturn ? StringUtils.stripIndentation((String)JavaCodeUtils.removeReturn(result)) : result;
        boolean removeSemicolon = (Boolean)this.opts.get(REMOVE_SEMICOLON_KEY, (Object)false);
        result = removeSemicolon ? JavaCodeUtils.removeSemicolonAtEnd(result) : result;
        return result;
    }

    private Collector<CharSequence, ?, String> collectorWithSeparator() {
        return Collectors.joining(EntriesSeparatorUtils.enrichUserTextEntriesSeparator((String)this.entrySeparator));
    }
}

