/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import org.apache.commons.io.FilenameUtils;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCodeBlockSimple;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DoxygenProgramListingParser {
    private final Node node;
    private final StringBuilder codeBlock;
    private final String fileName;

    private DoxygenProgramListingParser(Node node) {
        this.node = node;
        this.codeBlock = new StringBuilder();
        this.fileName = XmlUtils.getAttributeText((Node)node, (String)"filename", (String)"");
    }

    public static DoxygenCodeBlockSimple parseAsSimpleCodeBlock(Node node) {
        DoxygenProgramListingParser parser = new DoxygenProgramListingParser(node);
        return parser.parse();
    }

    private DoxygenCodeBlockSimple parse() {
        XmlUtils.childrenNodesStreamByName((Node)this.node, (String)"codeline").forEach(this::handleLine);
        return new DoxygenCodeBlockSimple(FilenameUtils.getExtension((String)this.fileName), this.codeBlock.toString());
    }

    private void handleLine(Node lineNode) {
        XmlUtils.forEach((NodeList)lineNode.getChildNodes(), this::extractText);
        this.codeBlock.append("\n");
    }

    private void extractText(Node node) {
        if (node.getNodeName().equals("sp")) {
            this.codeBlock.append(" ");
        } else if (node.getNodeType() == 3) {
            this.codeBlock.append(node.getTextContent());
        }
        XmlUtils.forEach((NodeList)node.getChildNodes(), this::extractText);
    }
}

