/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.plugin;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.Doxygen;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMembersList;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenMemberListExtractor;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class DoxygenDocIncludePlugin
implements IncludePlugin {
    private DoxygenMembersList membersList;
    private DoxygenCompound compound;

    public String id() {
        return "doxygen-doc";
    }

    public IncludePlugin create() {
        return DoxygenDocIncludePlugin.createDocPlugin();
    }

    public static IncludePlugin createDocPlugin() {
        return new DoxygenDocIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        Doxygen doxygen = Doxygen.INSTANCE;
        this.membersList = new DoxygenMembersList();
        String fullName = pluginParams.getFreeParam();
        this.compound = doxygen.getCachedOrFindAndParseCompound(componentsRegistry, fullName);
        if (this.compound == null) {
            this.membersList = DoxygenMemberListExtractor.extract(doxygen, componentsRegistry, pluginParams.getOpts(), false, pluginParams.getFreeParam());
        }
        if (this.compound == null && this.membersList.isEmpty()) {
            throw new RuntimeException("can't find entry: " + fullName + ", available names:\n" + doxygen.buildIndexOrGetCached(componentsRegistry).renderAvailableNames());
        }
        if (this.compound != null) {
            return PluginResult.docElements(this.compound.getDescription().docElementStream());
        }
        return PluginResult.docElements(this.membersList.first().getDescription().docElementStream());
    }

    public SearchText textForSearch() {
        return this.membersList.isEmpty() ? SearchScore.HIGH.text(this.compound.getDescription().textForSearch()) : SearchScore.HIGH.text(this.membersList.first().getDescription().textForSearch());
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)Doxygen.INSTANCE.getIndexPath()));
    }
}

