/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescriptionParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenTextWithLinksParser;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;

public class DoxygenMemberParser {
    private final ComponentsRegistry componentsRegistry;
    private final Node memberNode;
    private final DoxygenMember member;

    private DoxygenMemberParser(ComponentsRegistry componentsRegistry, Node memberNode) {
        this.componentsRegistry = componentsRegistry;
        this.memberNode = memberNode;
        this.member = new DoxygenMember();
    }

    public static DoxygenMember parse(ComponentsRegistry componentsRegistry, Node memberNode) {
        DoxygenMemberParser parser = new DoxygenMemberParser(componentsRegistry, memberNode);
        parser.parseXml();
        return parser.member;
    }

    private void parseXml() {
        this.parseMember(this.memberNode);
    }

    private void parseMember(Node memberNode) {
        this.member.setId(XmlUtils.getAttributeText((Node)memberNode, (String)"id"));
        this.member.setName(XmlUtils.nextLevelNodeByName((Node)memberNode, (String)"name").getTextContent());
        this.member.setKind(XmlUtils.getAttributeText((Node)memberNode, (String)"kind"));
        this.member.setVisibility(XmlUtils.getAttributeText((Node)memberNode, (String)"prot"));
        this.member.setStatic("yes".equals(XmlUtils.getAttributeText((Node)memberNode, (String)"static")));
        this.member.setVirtual("virtual".equals(XmlUtils.getAttributeText((Node)memberNode, (String)"virt")));
        this.member.setConst("yes".equals(XmlUtils.getAttributeText((Node)memberNode, (String)"const")));
        DocStructure docStructure = this.componentsRegistry.docStructure();
        this.member.setReturnType(DoxygenTextWithLinksParser.parse(docStructure, XmlUtils.nextLevelNodeByName((Node)memberNode, (String)"type")));
        XmlUtils.childrenNodesStreamByName((Node)memberNode, (String)"param").forEach(paramNode -> {
            String name = XmlUtils.nextLevelNodeByName((Node)paramNode, (String)"declname").getTextContent();
            ApiLinkedText type = DoxygenTextWithLinksParser.parse(docStructure, XmlUtils.nextLevelNodeByName((Node)paramNode, (String)"type"));
            this.member.addParameter(name, type);
        });
        this.member.buildNormalizedParamsSignature();
        if (XmlUtils.hasNodeByName((Node)memberNode, (String)"templateparamlist")) {
            Node templateParamsNode = XmlUtils.nextLevelNodeByName((Node)memberNode, (String)"templateparamlist");
            XmlUtils.childrenNodesStreamByName((Node)templateParamsNode, (String)"param").forEach(paramNode -> {
                ApiLinkedText type = DoxygenTextWithLinksParser.parse(docStructure, XmlUtils.nextLevelNodeByName((Node)paramNode, (String)"type"));
                this.member.addTemplateParameter("", type);
            });
        }
        this.member.setDescription(new DoxygenDescription(DoxygenDescriptionParser.parseBrief(this.componentsRegistry, XmlUtils.anyNestedNodeByName((Node)memberNode, (String)"briefdescription")), DoxygenDescriptionParser.parseFull(this.componentsRegistry, this.member.getParameters(), this.member.getName(), XmlUtils.anyNestedNodeByName((Node)memberNode, (String)"detaileddescription"))));
    }
}

