/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenUtils;

public class DoxygenIndex {
    private final Map<String, DoxygenIndexCompound> compoundById = new LinkedHashMap<String, DoxygenIndexCompound>();
    private final Map<String, DoxygenIndexMember> memberById = new LinkedHashMap<String, DoxygenIndexMember>();

    public void addCompound(DoxygenIndexCompound compound) {
        this.compoundById.put(compound.getId(), compound);
    }

    public void addMember(DoxygenIndexMember member) {
        this.memberById.put(member.getId(), member);
    }

    public Map<String, DoxygenIndexCompound> getCompoundById() {
        return this.compoundById;
    }

    public Map<String, DoxygenIndexMember> getMemberById() {
        return this.memberById;
    }

    public DoxygenIndexCompound findCompoundByName(String fullName) {
        return this.compoundById.values().stream().filter(c -> fullName.equals(c.getName())).findFirst().orElse(null);
    }

    public DoxygenIndexMember findMemberByName(String fullName) {
        return this.memberById.values().stream().filter(m -> fullName.equals(m.getFullName())).findFirst().orElse(null);
    }

    public List<DoxygenIndexMember> findAllMembersByName(String fullName) {
        return this.memberById.values().stream().filter(m -> fullName.equals(m.getFullName())).collect(Collectors.toList());
    }

    public String renderAvailableNames() {
        return this.renderNames(Stream.concat(this.availableCompoundNamesStream(), this.availableMemberNamesStream()));
    }

    public String renderAvailableMemberNames() {
        return this.renderNames(this.availableMemberNamesStream());
    }

    public String renderAvailableCompoundNames() {
        return this.renderNames(this.availableMemberNamesStream());
    }

    private String renderNames(Stream<String> names) {
        return names.sorted().distinct().collect(Collectors.joining("\n"));
    }

    private Stream<String> availableMemberNamesStream() {
        return this.memberById.values().stream().map(DoxygenIndexMember::getFullName);
    }

    private Stream<String> availableCompoundNamesStream() {
        return this.compoundById.values().stream().filter(c -> !DoxygenUtils.compoundNameOrEmptyForFile(c.getKind(), c.getName()).isEmpty()).map(DoxygenIndexCompound::getName);
    }
}

