/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cpp.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.testingisdocumenting.znai.cpp.ClassDefBuilder;
import org.testingisdocumenting.znai.cpp.parser.CPP14Parser;
import org.testingisdocumenting.znai.cpp.parser.EntryDef;

class ObjectsDefinitionTokensProcessor {
    private List<String> lines;
    private ArrayList<EntryDef> classDefs;
    private ParseState parseState;
    private ClassDefBuilder currentClassDefBuilder;

    public ObjectsDefinitionTokensProcessor(List<String> lines) {
        this.lines = lines;
        this.parseState = ParseState.LOOKING_FOR_OBJECT;
    }

    public List<EntryDef> process(CPP14Parser parser) {
        this.classDefs = new ArrayList();
        TokenStream stream = parser.getTokenStream();
        for (int i = 0; i < stream.size(); ++i) {
            Token token = stream.get(i);
            this.processToken(token);
        }
        return this.classDefs;
    }

    private boolean processToken(Token token) {
        if (token.getType() == -1) {
            return false;
        }
        switch (this.parseState) {
            case LOOKING_FOR_OBJECT: {
                return this.lookingForObject(token);
            }
            case LOOKING_FOR_IDENTIFIER: {
                return this.lookingForIdentifier(token);
            }
            case LOOKING_FOR_SCOPE_OPEN: {
                return this.lookingForScopeOpen(token);
            }
            case LOOKING_FOR_SCOPE_CLOSE: {
                return this.lookingForScopeClose(token);
            }
        }
        return false;
    }

    private boolean lookingForScopeOpen(Token token) {
        if (!this.isScopeOpen(token)) {
            return false;
        }
        this.currentClassDefBuilder.scopeOpen();
        return this.changeState(ParseState.LOOKING_FOR_SCOPE_CLOSE);
    }

    private boolean lookingForScopeClose(Token token) {
        this.currentClassDefBuilder.addToBody(token.getText());
        if (this.isScopeOpen(token)) {
            this.currentClassDefBuilder.scopeOpen();
        } else if (this.isScopeClose(token)) {
            this.currentClassDefBuilder.scopeClose();
            if (this.currentClassDefBuilder.isMainScopeClosed()) {
                this.currentClassDefBuilder.setEndLine(token.getLine());
                this.classDefs.add(this.currentClassDefBuilder.build());
                return this.changeState(ParseState.LOOKING_FOR_OBJECT);
            }
        }
        return false;
    }

    private boolean lookingForObject(Token token) {
        if (!this.isClassEnumOrStruct(token)) {
            return false;
        }
        this.currentClassDefBuilder = new ClassDefBuilder(this.lines);
        this.currentClassDefBuilder.setStartLine(token.getLine());
        return this.changeState(ParseState.LOOKING_FOR_IDENTIFIER);
    }

    private boolean lookingForIdentifier(Token token) {
        if (!this.isIdentifier(token)) {
            return false;
        }
        this.currentClassDefBuilder.setName(token.getText());
        return this.changeState(ParseState.LOOKING_FOR_SCOPE_OPEN);
    }

    private boolean changeState(ParseState newState) {
        this.parseState = newState;
        return true;
    }

    private boolean isScopeOpen(Token token) {
        return token.getType() == 82;
    }

    private boolean isScopeClose(Token token) {
        return token.getType() == 83;
    }

    private boolean isIdentifier(Token token) {
        return token.getType() == 125;
    }

    private boolean isClassEnumOrStruct(Token token) {
        return this.isClass(token) || this.isEnum(token) || this.isStruct(token);
    }

    private boolean isClass(Token token) {
        return token.getType() == 14;
    }

    private boolean isEnum(Token token) {
        return token.getType() == 26;
    }

    private boolean isStruct(Token token) {
        return token.getType() == 59;
    }

    private static enum ParseState {
        LOOKING_FOR_OBJECT,
        LOOKING_FOR_IDENTIFIER,
        LOOKING_FOR_SCOPE_OPEN,
        LOOKING_FOR_SCOPE_CLOSE;

    }
}

