/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import examples.GreetingsModule;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreetingsServer {
    public static final int DEFAULT_PORT = 50051;
    private static final Logger LOGGER = LoggerFactory.getLogger(GreetingsServer.class);
    private Server server;

    public void start() throws IOException {
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)50051);
        Injector injector = Guice.createInjector((Module[])new Module[]{new GreetingsModule()});
        TypeLiteral typeLiteral = TypeLiteral.get((Type)Types.setOf(BindableService.class));
        Key key = Key.get((TypeLiteral)typeLiteral);
        ((Set)injector.getInstance(key)).forEach(arg_0 -> ((ServerBuilder)serverBuilder).addService(arg_0));
        this.server = serverBuilder.build().start();
        LOGGER.info("Server started, listening on {}", (Object)this.server.getPort());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                GreetingsServer.this.stop();
            }
        });
    }

    public void stop() {
        if (this.server != null) {
            LOGGER.info("Server shutting down");
            this.server.shutdownNow();
        }
    }

    public void block() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        GreetingsServer greetingsServer = new GreetingsServer();
        greetingsServer.start();
        greetingsServer.block();
    }
}

