/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.framework.junit5;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.stage.Stage;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.testfx.api.FxRobot;
import org.testfx.api.FxToolkit;
import org.testfx.framework.junit5.ApplicationAdapter;
import org.testfx.framework.junit5.ApplicationFixture;
import org.testfx.framework.junit5.Init;
import org.testfx.framework.junit5.Start;
import org.testfx.framework.junit5.Stop;
import org.testfx.util.WaitForAsyncUtils;

public class ApplicationExtension
extends FxRobot
implements BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor,
ParameterResolver {
    private ApplicationFixture applicationFixture;

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Field[] fields;
        Method[] methods;
        ArrayList<Method> init = new ArrayList<Method>();
        ArrayList<Method> start = new ArrayList<Method>();
        ArrayList<Method> stop = new ArrayList<Method>();
        Class<?> testClass = testInstance.getClass();
        for (Method method : methods = testClass.getDeclaredMethods()) {
            method.setAccessible(true);
            if (method.isAnnotationPresent(Init.class)) {
                init.add(this.validateInitMethod(method));
            }
            if (method.isAnnotationPresent(Start.class)) {
                start.add(this.validateStartMethod(method));
            }
            if (!method.isAnnotationPresent(Stop.class)) continue;
            stop.add(this.validateStopMethod(method));
        }
        for (Field field : fields = testClass.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(FxRobot.class)) continue;
            this.setField(testInstance, field, (Object)this);
        }
        this.applicationFixture = new AnnotationBasedApplicationFixture(testInstance, init, start, stop);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType().isAssignableFrom(FxRobot.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        FxToolkit.registerPrimaryStage();
        FxToolkit.setupApplication(() -> new ApplicationAdapter(this.applicationFixture));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        FxToolkit.cleanupApplication((Application)new ApplicationAdapter(this.applicationFixture));
        this.release(new KeyCode[0]);
        this.release(new MouseButton[0]);
        WaitForAsyncUtils.waitForFxEvents();
    }

    private Method validateInitMethod(Method initMethod) {
        if (initMethod.getParameterCount() != 0) {
            throw new IllegalStateException("Method annotated with @Init should have no arguments");
        }
        return initMethod;
    }

    private Method validateStartMethod(Method startMethod) {
        Class<?>[] parameterTypes = startMethod.getParameterTypes();
        if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(Stage.class)) {
            throw new IllegalStateException("Method annotated with @Start should have one argument of type javafx.stage.Stage");
        }
        return startMethod;
    }

    private Method validateStopMethod(Method stopMethod) {
        if (stopMethod.getParameterCount() != 0) {
            throw new IllegalStateException("Method annotated with @Stop should have no arguments");
        }
        return stopMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Object instance, Field field, Object val) throws IllegalAccessException {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, val);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    private static class AnnotationBasedApplicationFixture
    implements ApplicationFixture {
        private final Object testInstance;
        private final List<Method> init;
        private final List<Method> start;
        private final List<Method> stop;

        private AnnotationBasedApplicationFixture(Object testInstance, List<Method> init, List<Method> start, List<Method> stop) {
            this.testInstance = testInstance;
            this.init = init;
            this.start = start;
            this.stop = stop;
        }

        @Override
        public void init() throws InvocationTargetException, IllegalAccessException {
            for (Method method : this.init) {
                method.invoke(this.testInstance, new Object[0]);
            }
        }

        @Override
        public void start(Stage stage) throws InvocationTargetException, IllegalAccessException {
            for (Method method : this.start) {
                method.invoke(this.testInstance, stage);
            }
        }

        @Override
        public void stop() throws InvocationTargetException, IllegalAccessException {
            for (Method method : this.stop) {
                method.invoke(this.testInstance, new Object[0]);
            }
        }
    }
}

