/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.TouchFilter;
import com.sun.glass.ui.monocle.TouchState;

class LookaheadTouchFilter
implements TouchFilter {
    private TouchState previousState = new TouchState();
    private TouchState tmpState = new TouchState();
    private boolean assignIDs;
    private FilterState filterState = FilterState.CLEAN;

    LookaheadTouchFilter(boolean assignIDs) {
        this.assignIDs = assignIDs;
    }

    @Override
    public boolean filter(TouchState state) {
        state.sortPointsByID();
        switch (this.filterState.ordinal()) {
            case 0: {
                state.copyTo(this.previousState);
                this.filterState = FilterState.PENDING_UNMODIFIABLE;
                return true;
            }
            case 1: {
                state.copyTo(this.tmpState);
                this.previousState.copyTo(state);
                this.tmpState.copyTo(this.previousState);
                if (state.canBeFoldedWith(this.previousState, this.assignIDs)) {
                    this.filterState = FilterState.PENDING_MODIFIABLE;
                }
                return false;
            }
            case 2: {
                if (state.canBeFoldedWith(this.previousState, this.assignIDs)) {
                    state.copyTo(this.previousState);
                    return true;
                }
                state.copyTo(this.tmpState);
                this.previousState.copyTo(state);
                this.tmpState.copyTo(this.previousState);
                this.filterState = FilterState.PENDING_UNMODIFIABLE;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean flush(TouchState state) {
        switch (this.filterState.ordinal()) {
            case 1: 
            case 2: {
                this.previousState.copyTo(state);
                this.filterState = FilterState.CLEAN;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 101;
    }

    public String toString() {
        return "Lookahead[previousState=" + String.valueOf(this.previousState) + ",filterState=" + String.valueOf((Object)this.filterState) + "]";
    }

    private static enum FilterState {
        CLEAN,
        PENDING_UNMODIFIABLE,
        PENDING_MODIFIABLE;

    }
}

