/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import java.util.Arrays;

class IntSet {
    private int[] elements = new int[4];
    private int size = 0;

    IntSet() {
    }

    void addInt(int value) {
        int i = this.getIndex(value);
        if (i < 0) {
            int insertionPoint = -1 - i;
            if (this.size == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, this.size * 2);
            }
            if (insertionPoint != this.size) {
                System.arraycopy(this.elements, insertionPoint, this.elements, insertionPoint + 1, this.size - insertionPoint);
            }
            this.elements[insertionPoint] = value;
            ++this.size;
        }
    }

    void removeInt(int value) {
        int i = this.getIndex(value);
        if (i >= 0) {
            if (i < this.size - 1) {
                System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i - 1);
            }
            --this.size;
        }
    }

    boolean containsInt(int value) {
        return this.getIndex(value) >= 0;
    }

    private int getIndex(int value) {
        int i;
        for (i = 0; i < this.size; ++i) {
            if (this.elements[i] == value) {
                return i;
            }
            if (this.elements[i] <= value) continue;
            return -i - 1;
        }
        return -i - 1;
    }

    int get(int index) {
        return this.elements[index];
    }

    void difference(IntSet dest, IntSet compared) {
        int i = 0;
        int j = 0;
        while (i < this.size && j < compared.size) {
            int a = this.elements[i];
            int b = compared.elements[j];
            if (a < b) {
                dest.addInt(a);
                ++i;
                continue;
            }
            if (a > b) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        while (i < this.size) {
            dest.addInt(this.elements[i]);
            ++i;
        }
    }

    void clear() {
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void copyTo(IntSet target) {
        if (target.elements.length < this.size) {
            target.elements = Arrays.copyOf(this.elements, this.elements.length);
        } else {
            System.arraycopy(this.elements, 0, target.elements, 0, this.size);
        }
        target.size = this.size;
    }

    public boolean equals(IntSet set) {
        if (set.size == this.size) {
            for (int i = 0; i < this.size; ++i) {
                if (set.elements[i] == this.elements[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof IntSet) {
            return this.equals((IntSet)o);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        for (int i = 0; i < this.size; ++i) {
            h = 31 * h + this.elements[i];
        }
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IntSet[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.elements[i]);
            if (i >= this.size - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

