/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AndroidInputDevice;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.TouchInput;
import com.sun.glass.ui.monocle.TouchPipeline;
import com.sun.glass.ui.monocle.TouchState;
import javafx.application.Platform;

class AndroidInputProcessor {
    private final AndroidInputDevice device;
    final TouchPipeline touchPipeline;
    private final KeyInput keyInput = new KeyInput();

    AndroidInputProcessor(AndroidInputDevice device) {
        this.device = device;
        this.touchPipeline = new TouchPipeline();
        this.touchPipeline.add(TouchInput.getInstance().getBasePipeline());
    }

    void pushEvent(TouchState state) {
        this.touchPipeline.pushState(state);
    }

    void processEvents(AndroidInputDevice device) {
        this.touchPipeline.pushState(null);
    }

    synchronized void pushKeyEvent(KeyState keyState) {
        this.keyInput.setState(keyState);
    }

    synchronized void dispatchKeyEvent(int type, int key, char[] chars, int modifiers) {
        Platform.runLater(() -> {
            MonocleWindow window = MonocleWindowManager.getInstance().getFocusedWindow();
            if (window == null) {
                return;
            }
            MonocleView view = (MonocleView)window.getView();
            if (view == null) {
                return;
            }
            RunnableProcessor.runLater(() -> view.notifyKey(type, key, chars, modifiers));
        });
    }

    synchronized void dispatchMenuEvent(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        Platform.runLater(() -> {
            MonocleWindow window = MonocleWindowManager.getInstance().getFocusedWindow();
            if (window == null) {
                return;
            }
            MonocleView view = (MonocleView)window.getView();
            if (view == null) {
                return;
            }
            RunnableProcessor.runLater(() -> view.notifyMenu(x, y, xAbs, yAbs, isKeyboardTrigger));
        });
    }
}

