/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AssignPointIDTouchFilter;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.NearbyPointsTouchFilter;
import com.sun.glass.ui.monocle.SmallMoveTouchFilter;
import com.sun.glass.ui.monocle.TouchFilter;
import com.sun.glass.ui.monocle.TouchInput;
import com.sun.glass.ui.monocle.TouchState;
import java.util.ArrayList;

class TouchPipeline {
    private TouchInput touch = TouchInput.getInstance();
    private ArrayList<TouchFilter> filters = new ArrayList();
    private TouchState flushState = new TouchState();

    TouchPipeline() {
    }

    void add(TouchPipeline pipeline) {
        for (int i = 0; i < pipeline.filters.size(); ++i) {
            this.addFilter(pipeline.filters.get(i));
        }
    }

    void addNamedFilters(String filterNameList) {
        String[] touchFilterNames = filterNameList.split(",");
        if (touchFilterNames != null) {
            for (String touchFilterName : touchFilterNames) {
                String s = touchFilterName.trim();
                if (s.length() <= 0) continue;
                this.addNamedFilter(s);
            }
        }
    }

    void addNamedFilter(String filterName) {
        try {
            if (((String)filterName).equals("SmallMove")) {
                this.addFilter(new SmallMoveTouchFilter());
            } else if (((String)filterName).equals("NearbyPoints")) {
                this.addFilter(new NearbyPointsTouchFilter());
            } else if (((String)filterName).equals("AssignPointID")) {
                this.addFilter(new AssignPointIDTouchFilter());
            } else {
                if (!((String)filterName).contains(".")) {
                    filterName = "com.sun.glass.ui.monocle." + (String)filterName + "TouchFilter";
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this.addFilter((TouchFilter)loader.loadClass((String)filterName).newInstance());
            }
        }
        catch (Exception e) {
            System.err.println("Cannot install touch filter '" + (String)filterName + "'");
            e.printStackTrace();
        }
    }

    void addFilter(TouchFilter filter) {
        int i;
        int priority = filter.getPriority();
        for (i = 0; i < this.filters.size(); ++i) {
            if (this.filters.get(i).equals(filter)) {
                return;
            }
            if (this.filters.get(i).getPriority() < priority) break;
        }
        this.filters.add(i, filter);
    }

    boolean filter(TouchState state) {
        for (int i = 0; i < this.filters.size(); ++i) {
            TouchFilter filter = this.filters.get(i);
            if (MonocleSettings.settings.traceEventsVerbose) {
                MonocleTrace.traceEvent("Applying %s to %s", filter, state);
            }
            if (!filter.filter(state)) continue;
            return true;
        }
        return false;
    }

    void pushState(TouchState state) {
        if (MonocleSettings.settings.traceEventsVerbose) {
            MonocleTrace.traceEvent("Pushing %s to %s", state, this);
        }
        if (!this.filter(state)) {
            this.touch.setState(state);
        }
    }

    void flush() {
        for (int i = 0; i < this.filters.size(); ++i) {
            TouchFilter filter = this.filters.get(i);
            while (filter.flush(this.flushState)) {
                if (MonocleSettings.settings.traceEventsVerbose) {
                    MonocleTrace.traceEvent("Flushing %s from %s", this.flushState, filter);
                }
                boolean consumed = false;
                for (int j = i + 1; j < this.filters.size() && !consumed; ++j) {
                    consumed = this.filters.get(j).filter(this.flushState);
                }
                if (consumed) continue;
                this.touch.setState(this.flushState);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TouchPipeline[");
        for (int i = 0; i < this.filters.size(); ++i) {
            sb.append(this.filters.get(i));
            if (i >= this.filters.size() - 1) continue;
            sb.append(" -> ");
        }
        sb.append("]");
        return sb.toString();
    }
}

