/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.strategy;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.YugabyteDBYSQLContainer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public final class YugabyteDBYSQLWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(YugabyteDBYSQLWaitStrategy.class);
    private final WaitStrategyTarget target;
    private static final String YSQL_EXTENDED_PROBE = "CREATE TABLE IF NOT EXISTS YB_SAMPLE(k int, v int, primary key(k, v))";
    private static final String YSQL_EXTENDED_PROBE_DROP_TABLE = "DROP TABLE IF EXISTS YB_SAMPLE";

    public void waitUntilReady(WaitStrategyTarget target) {
        YugabyteDBYSQLContainer container = (YugabyteDBYSQLContainer)target;
        Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            this.getRateLimiter().doWhenReady(() -> {
                try (Connection con = container.createConnection("");
                     Statement stmt = con.createStatement();){
                    stmt.execute(YSQL_EXTENDED_PROBE);
                    stmt.execute(YSQL_EXTENDED_PROBE_DROP_TABLE);
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            });
            return true;
        });
    }

    public void waitUntilReady() {
        this.waitUntilReady(this.target);
    }

    public YugabyteDBYSQLWaitStrategy(WaitStrategyTarget target) {
        this.target = target;
    }
}

