/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.migration.runner;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.testcontainers.jooq.codegen.migration.runner.MigrationRunner;
import org.testcontainers.jooq.codegen.migration.runner.RunnerProperties;

public class LiquibaseRunner
implements MigrationRunner {
    @Parameter(name="liquibase.changeLogPath", required=true)
    private String changeLogPath;
    @Parameter(name="liquibase.changeLogDirectory")
    private String changeLogDirectory;
    @Parameter(name="liquibase.parameters")
    private Map<String, String> parameters;
    @Parameter(name="liquibase.defaultSchemaName")
    private String defaultSchemaName;
    @Parameter(name="liquibase.liquibaseSchemaName")
    private String liquibaseSchemaName;
    @Parameter(name="liquibase.databaseChangeLogTableName")
    private String databaseChangeLogTableName;
    @Parameter(name="liquibase.databaseChangeLogLockTableName")
    private String databaseChangeLogLockTableName;

    @Override
    public void run(RunnerProperties runnerProperties) throws MojoExecutionException {
        try {
            Driver driver = runnerProperties.driver();
            Properties properties = new Properties();
            properties.put("user", runnerProperties.username());
            properties.put("password", runnerProperties.password());
            Connection c = driver.connect(runnerProperties.jdbcUrl(), properties);
            Database database = this.createDatabase(c);
            ResourceAccessor accessor = this.getResourceAccessor(runnerProperties);
            Liquibase liquibase = new Liquibase(this.changeLogPath, accessor, database);
            this.setParameters(liquibase);
            liquibase.update();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
        if (this.defaultSchemaName != null) {
            database.setDefaultSchemaName(this.defaultSchemaName);
        }
        Optional.ofNullable(this.liquibaseSchemaName).ifPresent(arg_0 -> ((Database)database).setLiquibaseSchemaName(arg_0));
        Optional.ofNullable(this.databaseChangeLogLockTableName).ifPresent(arg_0 -> ((Database)database).setDatabaseChangeLogLockTableName(arg_0));
        Optional.ofNullable(this.databaseChangeLogTableName).ifPresent(arg_0 -> ((Database)database).setDatabaseChangeLogTableName(arg_0));
        return database;
    }

    private void setParameters(Liquibase liquibase) {
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    private ResourceAccessor getResourceAccessor(RunnerProperties properties) throws FileNotFoundException {
        ArrayList<Object> resourceAccessors = new ArrayList<Object>();
        resourceAccessors.add(new ClassLoaderResourceAccessor((ClassLoader)properties.mavenClassloader()));
        resourceAccessors.add(new ClassLoaderResourceAccessor(this.getClass().getClassLoader()));
        resourceAccessors.add(new DirectoryResourceAccessor(properties.mavenProject().getBasedir()));
        ResourceAccessor[] array = (ResourceAccessor[])resourceAccessors.toArray(ResourceAccessor[]::new);
        return new SearchPathResourceAccessor(this.changeLogDirectory, array);
    }
}

