/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okhttp3.internal.http;

import java.io.Closeable;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.Unit;
import org.testcontainers.shaded.kotlin.io.CloseableKt;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.kotlin.jvm.internal.SourceDebugExtension;
import org.testcontainers.shaded.okhttp3.MediaType;
import org.testcontainers.shaded.okhttp3.RequestBody;
import org.testcontainers.shaded.okio.BufferedSink;
import org.testcontainers.shaded.okio.GzipSink;
import org.testcontainers.shaded.okio.Okio;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/http/GzipRequestBody;", "Lorg/testcontainers/shaded/okhttp3/RequestBody;", "delegate", "<init>", "(Lokhttp3/RequestBody;)V", "getDelegate", "()Lokhttp3/RequestBody;", "contentType", "Lorg/testcontainers/shaded/okhttp3/MediaType;", "contentLength", "", "writeTo", "", "sink", "Lorg/testcontainers/shaded/okio/BufferedSink;", "isOneShot", "", "okhttp"})
@SourceDebugExtension(value={"SMAP\nGzipRequestBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipRequestBody.kt\nokhttp3/internal/http/GzipRequestBody\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class GzipRequestBody
extends RequestBody {
    @NotNull
    private final RequestBody delegate;

    public GzipRequestBody(@NotNull RequestBody delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        this.delegate = delegate;
    }

    @NotNull
    public final RequestBody getDelegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.delegate.contentType();
    }

    @Override
    public long contentLength() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@NotNull BufferedSink sink2) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Closeable closeable = Okio.buffer(new GzipSink(sink2));
        RequestBody requestBody = this.delegate;
        Throwable throwable = null;
        try {
            BufferedSink p0 = (BufferedSink)closeable;
            boolean bl = false;
            requestBody.writeTo(p0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    public boolean isOneShot() {
        return this.delegate.isOneShot();
    }
}

