/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.rnorth.ducttape.timeouts.Timeouts;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DefaultRecordingFileFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.RecordingFileFactory;
import org.testcontainers.containers.SeleniumUtils;
import org.testcontainers.containers.VncRecordingContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.shaded.com.google.common.collect.ImmutableSet;
import org.testcontainers.utility.DockerImageName;

public class BrowserWebDriverContainer<SELF extends BrowserWebDriverContainer<SELF>>
extends GenericContainer<SELF>
implements LinkableContainer,
TestLifecycleAware {
    private static final DockerImageName CHROME_IMAGE = DockerImageName.parse((String)"selenium/standalone-chrome-debug");
    private static final DockerImageName FIREFOX_IMAGE = DockerImageName.parse((String)"selenium/standalone-firefox-debug");
    private static final DockerImageName[] COMPATIBLE_IMAGES = new DockerImageName[]{CHROME_IMAGE, FIREFOX_IMAGE, DockerImageName.parse((String)"selenium/standalone-chrome"), DockerImageName.parse((String)"selenium/standalone-firefox")};
    private static final String DEFAULT_PASSWORD = "secret";
    private static final int SELENIUM_PORT = 4444;
    private static final int VNC_PORT = 5900;
    private static final String NO_PROXY_KEY = "no_proxy";
    private static final String TC_TEMP_DIR_PREFIX = "tc";
    @Nullable
    private Capabilities capabilities;
    private DockerImageName customImageName = null;
    @Nullable
    private RemoteWebDriver driver;
    private VncRecordingMode recordingMode = VncRecordingMode.RECORD_FAILING;
    private VncRecordingContainer.VncRecordingFormat recordingFormat;
    private RecordingFileFactory recordingFileFactory;
    private File vncRecordingDirectory;
    private VncRecordingContainer vncRecordingContainer = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserWebDriverContainer.class);

    public BrowserWebDriverContainer() {
        WaitStrategy logWaitStrategy = new LogMessageWaitStrategy().withRegEx(".*(RemoteWebDriver instances should connect to|Selenium Server is up and running).*\n").withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS));
        this.waitStrategy = new WaitAllStrategy().withStrategy(logWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS));
        this.withRecordingFileFactory(new DefaultRecordingFileFactory());
    }

    public BrowserWebDriverContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public BrowserWebDriverContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        WaitStrategy logWaitStrategy = new LogMessageWaitStrategy().withRegEx(".*(RemoteWebDriver instances should connect to|Selenium Server is up and running).*\n").withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS));
        this.waitStrategy = new WaitAllStrategy().withStrategy(logWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS));
        this.withRecordingFileFactory(new DefaultRecordingFileFactory());
        this.customImageName = dockerImageName;
        this.recordingMode = VncRecordingMode.SKIP;
    }

    public SELF withCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    @Deprecated
    public SELF withDesiredCapabilities(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        Integer seleniumPort = this.getMappedPort(4444);
        if (this.recordingMode == VncRecordingMode.SKIP) {
            return ImmutableSet.of((Object)seleniumPort);
        }
        return ImmutableSet.of((Object)seleniumPort, (Object)this.getMappedPort(5900));
    }

    protected void configure() {
        String seleniumVersion = SeleniumUtils.determineClasspathSeleniumVersion();
        if (this.capabilities == null) {
            if (seleniumVersion.startsWith("2.")) {
                this.logger().info("No capabilities provided, falling back to DesiredCapabilities.chrome()");
                this.capabilities = DesiredCapabilities.chrome();
            } else {
                this.logger().info("No capabilities provided, falling back to ChromeOptions");
                this.capabilities = new ChromeOptions();
            }
        }
        if (this.recordingMode != VncRecordingMode.SKIP) {
            if (this.vncRecordingDirectory == null) {
                try {
                    this.vncRecordingDirectory = Files.createTempDirectory(TC_TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    this.logger().error("Exception while trying to create temp directory", (Throwable)e);
                    throw new ContainerLaunchException("Exception while trying to create temp directory", (Throwable)e);
                }
            }
            if (this.getNetwork() == null) {
                this.withNetwork(Network.SHARED);
            }
            this.vncRecordingContainer = new VncRecordingContainer((GenericContainer)this).withVncPassword(DEFAULT_PASSWORD).withVncPort(5900).withVideoFormat(this.recordingFormat);
        }
        if (this.customImageName != null) {
            this.customImageName.assertCompatibleWith(COMPATIBLE_IMAGES);
            super.setDockerImageName(this.customImageName.asCanonicalNameString());
        } else {
            DockerImageName standardImageForCapabilities = BrowserWebDriverContainer.getStandardImageForCapabilities(this.capabilities, seleniumVersion);
            super.setDockerImageName(standardImageForCapabilities.asCanonicalNameString());
        }
        String timeZone = System.getProperty("user.timezone");
        if (timeZone == null || timeZone.isEmpty()) {
            timeZone = "Etc/UTC";
        }
        this.addExposedPorts(new int[]{4444, 5900});
        this.addEnv("TZ", timeZone);
        if (!this.getEnvMap().containsKey(NO_PROXY_KEY)) {
            this.addEnv(NO_PROXY_KEY, "localhost");
        }
        this.setCommand("/opt/bin/entry_point.sh");
        if (this.getShmSize() == null) {
            this.getBinds().add(new Bind("/dev/shm", new Volume("/dev/shm"), AccessMode.rw));
        }
        this.setStartupAttempts(3);
    }

    @Deprecated
    public static String getDockerImageForCapabilities(Capabilities capabilities, String seleniumVersion) {
        return BrowserWebDriverContainer.getStandardImageForCapabilities(capabilities, seleniumVersion).asCanonicalNameString();
    }

    private static DockerImageName getStandardImageForCapabilities(Capabilities capabilities, String seleniumVersion) {
        String browserName;
        switch (browserName = capabilities.getBrowserName()) {
            case "chrome": {
                return CHROME_IMAGE.withTag(seleniumVersion);
            }
            case "firefox": {
                return FIREFOX_IMAGE.withTag(seleniumVersion);
            }
        }
        throw new UnsupportedOperationException("Browser name must be 'chrome' or 'firefox'; provided '" + browserName + "' is not supported");
    }

    public URL getSeleniumAddress() {
        try {
            return new URL("http", this.getHost(), this.getMappedPort(4444), "/wd/hub");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getVncAddress() {
        return "vnc://vnc:secret@" + this.getHost() + ":" + this.getMappedPort(5900);
    }

    @Deprecated
    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    @Deprecated
    public int getPort() {
        return 5900;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.driver = (RemoteWebDriver)Unreliables.retryUntilSuccess((int)30, (TimeUnit)TimeUnit.SECONDS, (Callable)((Callable)Timeouts.getWithTimeout((int)10, (TimeUnit)TimeUnit.SECONDS, () -> () -> new RemoteWebDriver(this.getSeleniumAddress(), this.capabilities))));
        if (this.vncRecordingContainer != null) {
            LOGGER.debug("Starting VNC recording");
            this.vncRecordingContainer.start();
        }
    }

    public RemoteWebDriver getWebDriver() {
        return this.driver;
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainRecordingIfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    public void stop() {
        if (this.driver != null) {
            try {
                this.driver.quit();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to quit the driver", (Throwable)e);
            }
        }
        if (this.vncRecordingContainer != null) {
            try {
                this.vncRecordingContainer.stop();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to stop vncRecordingContainer", (Throwable)e);
            }
        }
        super.stop();
    }

    private void retainRecordingIfNeeded(String prefix, boolean succeeded) {
        boolean shouldRecord;
        switch (this.recordingMode) {
            case RECORD_ALL: {
                shouldRecord = true;
                break;
            }
            case RECORD_FAILING: {
                shouldRecord = !succeeded;
                break;
            }
            default: {
                shouldRecord = false;
            }
        }
        if (shouldRecord) {
            File recordingFile = this.recordingFileFactory.recordingFileForTest(this.vncRecordingDirectory, prefix, succeeded, this.vncRecordingContainer.getVideoFormat());
            LOGGER.info("Screen recordings for test {} will be stored at: {}", (Object)prefix, (Object)recordingFile);
            this.vncRecordingContainer.saveRecordingToFile(recordingFile);
        }
    }

    @Deprecated
    public SELF withLinkToContainer(LinkableContainer otherContainer, String alias) {
        this.addLink(otherContainer, alias);
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingMode(VncRecordingMode recordingMode, File vncRecordingDirectory) {
        return this.withRecordingMode(recordingMode, vncRecordingDirectory, null);
    }

    public SELF withRecordingMode(VncRecordingMode recordingMode, File vncRecordingDirectory, VncRecordingContainer.VncRecordingFormat recordingFormat) {
        this.recordingMode = recordingMode;
        this.vncRecordingDirectory = vncRecordingDirectory;
        this.recordingFormat = recordingFormat;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingFileFactory(RecordingFileFactory recordingFileFactory) {
        this.recordingFileFactory = recordingFileFactory;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public static enum VncRecordingMode {
        SKIP,
        RECORD_ALL,
        RECORD_FAILING;

    }
}

