/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class MockServerContainer
extends GenericContainer<MockServerContainer> {
    private static final Logger log = LoggerFactory.getLogger(MockServerContainer.class);
    public static final String VERSION = "5.4.1";
    public static final int PORT = 80;

    public MockServerContainer() {
        this(VERSION);
    }

    public MockServerContainer(String version) {
        super("jamesdbloom/mockserver:mockserver-" + version);
        this.withCommand("/opt/mockserver/run_mockserver.sh -logLevel INFO -serverPort 80");
        this.addExposedPorts(new int[]{80});
    }

    public String getEndpoint() {
        return String.format("http://%s:%d", this.getContainerIpAddress(), this.getMappedPort(80));
    }

    public Integer getServerPort() {
        return this.getMappedPort(80);
    }
}

