/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;

public class MariaDBContainer<SELF extends MariaDBContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "mariadb";
    public static final String IMAGE = "mariadb";
    private static final Integer MARIADB_PORT = 3306;
    private static final String MARIADB_USER = "test";
    private static final String MARIADB_PASSWORD = "test";
    private static final String MARIADB_DATABASE = "test";
    private static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";

    public MariaDBContainer() {
        super("mariadb:latest");
    }

    public MariaDBContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(MARIADB_PORT);
    }

    protected void configure() {
        this.optionallyMapResourceParameterAsVolume(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, "/etc/mysql/conf.d");
        this.addExposedPort(MARIADB_PORT);
        this.addEnv("MYSQL_DATABASE", "test");
        this.addEnv("MYSQL_USER", "test");
        this.addEnv("MYSQL_PASSWORD", "test");
        this.addEnv("MYSQL_ROOT_PASSWORD", "test");
        this.setCommand("mysqld");
        this.setStartupAttempts(3);
    }

    public String getDriverClassName() {
        return "org.mariadb.jdbc.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:mariadb://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MARIADB_PORT) + "/test";
    }

    public String getUsername() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withConfigurationOverride(String s) {
        this.parameters.put(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, s);
        return (SELF)((Object)((MariaDBContainer)this.self()));
    }
}

