/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestcontainersConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TestcontainersConfiguration.class);
    private final Object $lock = new Object[0];
    private static String PROPERTIES_FILE_NAME = "testcontainers.properties";
    private static File GLOBAL_CONFIG_FILE = new File(System.getProperty("user.home"), "." + PROPERTIES_FILE_NAME);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Properties properties;

    public String getAmbassadorContainerImage() {
        return (String)this.properties.getOrDefault((Object)"ambassador.container.image", "richnorth/ambassador:latest");
    }

    public String getVncRecordedContainerImage() {
        return (String)this.properties.getOrDefault((Object)"vncrecorder.container.image", "richnorth/vnc-recorder:latest");
    }

    public String getTinyImage() {
        return (String)this.properties.getOrDefault((Object)"tinyimage.container.image", "alpine:3.5");
    }

    public boolean isDisableChecks() {
        return Boolean.parseBoolean((String)this.properties.getOrDefault((Object)"checks.disable", "false"));
    }

    public String getDockerClientStrategyClassName() {
        return (String)this.properties.get("docker.client.strategy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGlobalConfig(@NonNull String prop, @NonNull String value) {
        Object object = this.$lock;
        synchronized (object) {
            if (prop == null) {
                throw new NullPointerException("prop");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            try {
                Properties globalProperties = new Properties();
                GLOBAL_CONFIG_FILE.createNewFile();
                try (FileInputStream inputStream = new FileInputStream(GLOBAL_CONFIG_FILE);){
                    globalProperties.load(inputStream);
                }
                if (value.equals(globalProperties.get(prop))) {
                    return false;
                }
                globalProperties.setProperty(prop, value);
                var6_7 = null;
                try (FileOutputStream outputStream = new FileOutputStream(GLOBAL_CONFIG_FILE);){
                    globalProperties.store(outputStream, "Modified by Testcontainers");
                }
                catch (Throwable throwable) {
                    var6_7 = throwable;
                    throw throwable;
                }
                this.properties.setProperty(prop, value);
                return true;
            }
            catch (Exception e) {
                log.debug("Can't store global property {} in {}", (Object)prop, (Object)GLOBAL_CONFIG_FILE);
                return false;
            }
        }
    }

    private static TestcontainersConfiguration loadConfiguration() {
        TestcontainersConfiguration config = new TestcontainersConfiguration(Stream.of(TestcontainersConfiguration.class.getClassLoader().getResource(PROPERTIES_FILE_NAME), Thread.currentThread().getContextClassLoader().getResource(PROPERTIES_FILE_NAME), GLOBAL_CONFIG_FILE.toURI().toURL()).filter(Objects::nonNull).map(it -> {
            log.debug("Testcontainers configuration overrides will be loaded from {}", it);
            Properties subProperties = new Properties();
            try (InputStream inputStream = it.openStream();){
                subProperties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                log.trace("Testcontainers config override was found on " + it + " but the file was not found", e);
            }
            catch (IOException e) {
                log.warn("Testcontainers config override was found on " + it + " but could not be loaded", e);
            }
            return subProperties;
        }).reduce(new Properties(), (a, b) -> {
            a.putAll((Map<?, ?>)b);
            return a;
        }));
        if (!config.getProperties().isEmpty()) {
            log.debug("Testcontainers configuration overrides loaded from {}", (Object)config);
        }
        return config;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestcontainersConfiguration)) {
            return false;
        }
        TestcontainersConfiguration other = (TestcontainersConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestcontainersConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "TestcontainersConfiguration(properties=" + this.getProperties() + ")";
    }

    private TestcontainersConfiguration(Properties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestcontainersConfiguration getInstance() {
        Object value = instance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                value = instance.get();
                if (value == null) {
                    TestcontainersConfiguration actualValue = TestcontainersConfiguration.loadConfiguration();
                    value = actualValue == null ? instance : actualValue;
                    instance.set(value);
                }
            }
        }
        return (TestcontainersConfiguration)(value == instance ? null : value);
    }
}

