/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.handler.codec.socks;

import java.util.ArrayList;
import java.util.List;
import org.testcontainers.shaded.io.netty.buffer.ByteBuf;
import org.testcontainers.shaded.io.netty.channel.ChannelHandlerContext;
import org.testcontainers.shaded.io.netty.handler.codec.ReplayingDecoder;
import org.testcontainers.shaded.io.netty.handler.codec.socks.SocksAuthScheme;
import org.testcontainers.shaded.io.netty.handler.codec.socks.SocksCommonUtils;
import org.testcontainers.shaded.io.netty.handler.codec.socks.SocksInitRequest;
import org.testcontainers.shaded.io.netty.handler.codec.socks.SocksProtocolVersion;
import org.testcontainers.shaded.io.netty.handler.codec.socks.SocksRequest;

public class SocksInitRequestDecoder
extends ReplayingDecoder<State> {
    private final List<SocksAuthScheme> authSchemes = new ArrayList<SocksAuthScheme>();
    private SocksProtocolVersion version;
    private byte authSchemeNum;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public SocksInitRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksProtocolVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_AUTH_SCHEMES);
            }
            case READ_AUTH_SCHEMES: {
                this.authSchemes.clear();
                this.authSchemeNum = byteBuf.readByte();
                for (int i = 0; i < this.authSchemeNum; ++i) {
                    this.authSchemes.add(SocksAuthScheme.valueOf(byteBuf.readByte()));
                }
                this.msg = new SocksInitRequest(this.authSchemes);
            }
        }
        ctx.pipeline().remove(this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_SCHEMES;

    }
}

