/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;

public class EnvironmentAndSystemPropertyClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentAndSystemPropertyClientProviderStrategy.class);
    public static final int PRIORITY = 100;
    private static final String PING_TIMEOUT_DEFAULT = "10";
    private static final String PING_TIMEOUT_PROPERTY_NAME = "testcontainers.environmentprovider.timeout";

    public EnvironmentAndSystemPropertyClientProviderStrategy() {
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
    }

    @Override
    protected boolean isApplicable() {
        return "tcp".equalsIgnoreCase(this.config.getDockerHost().getScheme()) || SystemUtils.IS_OS_LINUX;
    }

    @Override
    protected int getPriority() {
        return 100;
    }

    @Override
    public void test() throws DockerClientProviderStrategy.InvalidConfigurationException {
        try {
            this.client = this.getClientForConfig(this.config);
            int timeout = Integer.parseInt(System.getProperty(PING_TIMEOUT_PROPERTY_NAME, PING_TIMEOUT_DEFAULT));
            this.ping(this.client, timeout);
        }
        catch (Exception | UnsatisfiedLinkError e) {
            log.error("ping failed with configuration {} due to {}", this.getDescription(), e.toString(), e);
            throw new DockerClientProviderStrategy.InvalidConfigurationException("ping failed");
        }
        log.info("Found docker client settings from environment");
    }

    @Override
    public String getDescription() {
        return "Environment variables, system properties and defaults. Resolved: \n" + this.stringRepresentation(this.config);
    }

    private String stringRepresentation(DockerClientConfig config) {
        if (config == null) {
            return "";
        }
        return "    dockerHost=" + config.getDockerHost() + "\n    apiVersion='" + config.getApiVersion() + "'\n    registryUrl='" + config.getRegistryUrl() + "'\n    registryUsername='" + config.getRegistryUsername() + "'\n    registryPassword='" + config.getRegistryPassword() + "'\n    registryEmail='" + config.getRegistryEmail() + "'\n    dockerConfig='" + config.toString() + "'\n";
    }
}

