/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.WaitingConsumer;

public class LogMessageWaitStrategy
extends GenericContainer.AbstractWaitStrategy {
    private String regEx;
    private int times = 1;

    @Override
    protected void waitUntilReady() {
        WaitingConsumer waitingConsumer = new WaitingConsumer();
        this.container.followOutput(waitingConsumer);
        Predicate<OutputFrame> waitPredicate = outputFrame -> outputFrame.getUtf8String().matches(this.regEx);
        try {
            waitingConsumer.waitUntil(waitPredicate, this.startupTimeout.getSeconds(), TimeUnit.SECONDS, this.times);
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for log output matching '" + this.regEx + "'");
        }
    }

    public LogMessageWaitStrategy withRegEx(String regEx) {
        this.regEx = regEx;
        return this;
    }

    public LogMessageWaitStrategy withTimes(int times) {
        this.times = times;
        return this;
    }
}

