/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.rnorth.visibleassertions.VisibleAssertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.DockerMachineClientProviderStrategy;
import org.testcontainers.dockerclient.EnvironmentAndSystemPropertyClientProviderStrategy;
import org.testcontainers.dockerclient.ProxiedUnixSocketClientProviderStrategy;
import org.testcontainers.dockerclient.UnixSocketClientProviderStrategy;
import org.testcontainers.dockerclient.WindowsClientProviderStrategy;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.TestcontainersConfiguration;

public class DockerClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DockerClientFactory.class);
    private final Object $lock = new Object[0];
    private static final String TINY_IMAGE = TestcontainersConfiguration.getInstance().getTinyImage();
    private static DockerClientFactory instance;
    private DockerClientProviderStrategy strategy;
    private boolean preconditionsChecked = false;
    private static final List<DockerClientProviderStrategy> CONFIGURATION_STRATEGIES;
    private String activeApiVersion;
    private String activeExecutionDriver;

    private DockerClientFactory() {
    }

    public static synchronized DockerClientFactory instance() {
        if (instance == null) {
            instance = new DockerClientFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient client() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.strategy != null) {
                return this.strategy.getClient();
            }
            this.strategy = DockerClientProviderStrategy.getFirstValidStrategy(CONFIGURATION_STRATEGIES);
            String hostIpAddress = this.strategy.getDockerHostIpAddress();
            log.info("Docker host IP address is {}", (Object)hostIpAddress);
            DockerClient client = this.strategy.getClient();
            if (!this.preconditionsChecked) {
                Info dockerInfo = (Info)client.infoCmd().exec();
                Version version = (Version)client.versionCmd().exec();
                this.activeApiVersion = version.getApiVersion();
                this.activeExecutionDriver = dockerInfo.getExecutionDriver();
                log.info("Connected to docker: \n  Server Version: " + dockerInfo.getServerVersion() + "\n  API Version: " + this.activeApiVersion + "\n  Operating System: " + dockerInfo.getOperatingSystem() + "\n  Total Memory: " + dockerInfo.getMemTotal() / 0x100000L + " MB");
                if (!TestcontainersConfiguration.getInstance().isDisableChecks()) {
                    VisibleAssertions.info("Checking the system...");
                    this.checkDockerVersion(version.getVersion());
                    MountableFile mountableFile = MountableFile.forClasspathResource(this.getClass().getName().replace(".", "/") + ".class");
                    this.runInsideDocker(client, cmd -> cmd.withCmd("/bin/sh", "-c", "while true; do printf 'hello' | nc -l -p 80; done").withBinds(new Bind(mountableFile.getResolvedPath(), new Volume("/dummy"), AccessMode.ro)).withExposedPorts(new ExposedPort(80)).withPublishAllPorts(true), (dockerClient, id) -> {
                        this.checkDiskSpace((DockerClient)dockerClient, (String)id);
                        this.checkMountableFile((DockerClient)dockerClient, (String)id);
                        this.checkExposedPort(hostIpAddress, (DockerClient)dockerClient, (String)id);
                        return null;
                    });
                }
                this.preconditionsChecked = true;
            }
            return client;
        }
    }

    private void checkDockerVersion(String dockerVersion) {
        VisibleAssertions.assertThat("Docker version", dockerVersion, new BaseMatcher<String>(){

            @Override
            public boolean matches(Object o) {
                return new ComparableVersion(o.toString()).compareTo(new ComparableVersion("1.6.0")) >= 0;
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("is newer than 1.6.0");
            }
        });
    }

    private void checkDiskSpace(DockerClient dockerClient, String id) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            dockerClient.execStartCmd(((ExecCreateCmdResponse)dockerClient.execCreateCmd(id).withAttachStdout(true).withCmd("df", "-P").exec()).getId()).exec(new ExecStartResultCallback(outputStream, null)).awaitCompletion();
        }
        catch (Exception e) {
            log.debug("Can't exec disk checking command", e);
        }
        DiskSpaceUsage df = this.parseAvailableDiskSpace(outputStream.toString());
        VisibleAssertions.assertTrue("Docker environment has more than 2GB free", df.availableMB.map(it -> it >= 2048).orElse(true));
    }

    private void checkMountableFile(DockerClient dockerClient, String id) {
        try (InputStream stream = dockerClient.copyArchiveFromContainerCmd(id, "/dummy").exec();){
            stream.read();
            VisibleAssertions.pass("File should be mountable");
        }
        catch (Exception e) {
            VisibleAssertions.fail("File should be mountable but fails with " + e.getMessage());
        }
    }

    private void checkExposedPort(String hostIpAddress, DockerClient dockerClient, String id) {
        String response;
        InspectContainerResponse inspectedContainer = dockerClient.inspectContainerCmd(id).exec();
        String portSpec = inspectedContainer.getNetworkSettings().getPorts().getBindings().values().iterator().next()[0].getHostPortSpec();
        try (Socket socket = new Socket(hostIpAddress, Integer.parseInt(portSpec));){
            response = IOUtils.toString(socket.getInputStream(), Charset.defaultCharset());
        }
        catch (IOException e) {
            response = e.getMessage();
        }
        VisibleAssertions.assertEquals("Exposed port is accessible", "hello", response);
    }

    private void checkAndPullImage(DockerClient client, String image) {
        List images = (List)client.listImagesCmd().withImageNameFilter(image).exec();
        if (images.isEmpty()) {
            client.pullImageCmd(image).exec(new PullImageResultCallback()).awaitSuccess();
        }
    }

    public String dockerHostIpAddress() {
        return this.strategy.getDockerHostIpAddress();
    }

    public <T> T runInsideDocker(Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        if (this.strategy == null) {
            this.client();
        }
        return this.runInsideDocker(this.strategy.getClient(), createContainerCmdConsumer, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runInsideDocker(DockerClient client, Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        this.checkAndPullImage(client, TINY_IMAGE);
        CreateContainerCmd createContainerCmd = client.createContainerCmd(TINY_IMAGE);
        createContainerCmdConsumer.accept(createContainerCmd);
        String id = createContainerCmd.exec().getId();
        try {
            client.startContainerCmd(id).exec();
            T t = block.apply(client, id);
            return t;
        }
        finally {
            try {
                client.removeContainerCmd(id).withRemoveVolumes(true).withForce(true).exec();
            }
            catch (InternalServerErrorException | NotFoundException ignored) {
                log.debug("", ignored);
            }
        }
    }

    private DiskSpaceUsage parseAvailableDiskSpace(String dfOutput) {
        String[] lines;
        DiskSpaceUsage df = new DiskSpaceUsage();
        for (String line : lines = dfOutput.split("\n")) {
            String[] fields = line.split("\\s+");
            if (fields.length <= 5 || !fields[5].equals("/")) continue;
            int availableKB = Integer.valueOf(fields[3]);
            df.availableMB = Optional.of(availableKB / 1024);
            df.usedPercent = Optional.of(Integer.valueOf(fields[4].replace("%", "")));
        }
        return df;
    }

    public String getActiveApiVersion() {
        if (!this.preconditionsChecked) {
            this.client();
        }
        return this.activeApiVersion;
    }

    public String getActiveExecutionDriver() {
        if (!this.preconditionsChecked) {
            this.client();
        }
        return this.activeExecutionDriver;
    }

    public boolean isUsing(Class<? extends DockerClientProviderStrategy> providerStrategyClass) {
        return providerStrategyClass.isAssignableFrom(this.strategy.getClass());
    }

    static {
        CONFIGURATION_STRATEGIES = Arrays.asList(new EnvironmentAndSystemPropertyClientProviderStrategy(), new UnixSocketClientProviderStrategy(), new ProxiedUnixSocketClientProviderStrategy(), new DockerMachineClientProviderStrategy(), new WindowsClientProviderStrategy());
        System.setProperty("org.testcontainers.shaded.io.netty.packagePrefix", "org.testcontainers.shaded.");
    }

    private static class NotEnoughDiskSpaceException
    extends RuntimeException {
        NotEnoughDiskSpaceException(String message) {
            super(message);
        }
    }

    private static class DiskSpaceUsage {
        Optional<Integer> availableMB = Optional.empty();
        Optional<Integer> usedPercent = Optional.empty();

        private DiskSpaceUsage() {
        }
    }
}

