/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.pqc.crypto.mceliece;

import org.testcontainers.shaded.org.bouncycastle.crypto.CipherParameters;
import org.testcontainers.shaded.org.bouncycastle.crypto.Digest;
import org.testcontainers.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.testcontainers.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.MessageEncryptor;

public class McEliecePKCSDigestCipher {
    private final Digest messDigest;
    private final MessageEncryptor mcElieceCipher;
    private boolean forEncrypting;

    public McEliecePKCSDigestCipher(MessageEncryptor messageEncryptor, Digest digest) {
        this.mcElieceCipher = messageEncryptor;
        this.messDigest = digest;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forEncrypting = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Encrypting Requires Public Key.");
        }
        if (!bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Decrypting Requires Private Key.");
        }
        this.reset();
        this.mcElieceCipher.init(bl, cipherParameters);
    }

    public byte[] messageEncrypt() {
        if (!this.forEncrypting) {
            throw new IllegalStateException("McEliecePKCSDigestCipher not initialised for encrypting.");
        }
        byte[] byArray = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray, 0);
        byte[] byArray2 = null;
        try {
            byArray2 = this.mcElieceCipher.messageEncrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] messageDecrypt(byte[] byArray) {
        byte[] byArray2 = null;
        if (this.forEncrypting) {
            throw new IllegalStateException("McEliecePKCSDigestCipher not initialised for decrypting.");
        }
        try {
            byArray2 = this.mcElieceCipher.messageDecrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public void update(byte by) {
        this.messDigest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.messDigest.update(byArray, n, n2);
    }

    public void reset() {
        this.messDigest.reset();
    }
}

