/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.handler.ssl;

import java.net.IDN;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;
import org.testcontainers.shaded.io.netty.buffer.ByteBuf;
import org.testcontainers.shaded.io.netty.buffer.ByteBufUtil;
import org.testcontainers.shaded.io.netty.channel.ChannelHandler;
import org.testcontainers.shaded.io.netty.channel.ChannelHandlerContext;
import org.testcontainers.shaded.io.netty.channel.ChannelOutboundHandler;
import org.testcontainers.shaded.io.netty.channel.ChannelPromise;
import org.testcontainers.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import org.testcontainers.shaded.io.netty.handler.codec.DecoderException;
import org.testcontainers.shaded.io.netty.handler.ssl.NotSslRecordException;
import org.testcontainers.shaded.io.netty.handler.ssl.SslContext;
import org.testcontainers.shaded.io.netty.handler.ssl.SslHandler;
import org.testcontainers.shaded.io.netty.handler.ssl.SslUtils;
import org.testcontainers.shaded.io.netty.util.AsyncMapping;
import org.testcontainers.shaded.io.netty.util.CharsetUtil;
import org.testcontainers.shaded.io.netty.util.DomainNameMapping;
import org.testcontainers.shaded.io.netty.util.Mapping;
import org.testcontainers.shaded.io.netty.util.concurrent.Future;
import org.testcontainers.shaded.io.netty.util.concurrent.FutureListener;
import org.testcontainers.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.testcontainers.shaded.io.netty.util.concurrent.Promise;
import org.testcontainers.shaded.io.netty.util.internal.ObjectUtil;
import org.testcontainers.shaded.io.netty.util.internal.logging.InternalLogger;
import org.testcontainers.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class SniHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final int MAX_SSL_RECORDS = 4;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SniHandler.class);
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    private final AsyncMapping<String, SslContext> mapping;
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private volatile Selection selection = EMPTY_SELECTION;

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter(mapping));
    }

    public SniHandler(DomainNameMapping<? extends SslContext> mapping) {
        this((Mapping<? super String, ? extends SslContext>)mapping);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping) {
        this.mapping = ObjectUtil.checkNotNull(mapping, "mapping");
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            block18: {
                writerIndex = in.writerIndex();
                try {
                    block6: for (i = 0; i < 4; ++i) {
                        readerIndex = in.readerIndex();
                        readableBytes = writerIndex - readerIndex;
                        if (readableBytes < 5) {
                            return;
                        }
                        command = in.getUnsignedByte(readerIndex);
                        switch (command) {
                            case 20: 
                            case 21: {
                                len = SslUtils.getEncryptedPacketLength(in, readerIndex);
                                if (len == -1) {
                                    this.handshakeFailed = true;
                                    e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(in));
                                    in.skipBytes(in.readableBytes());
                                    ctx.fireExceptionCaught(e);
                                    SslUtils.notifyHandshakeFailure(ctx, e);
                                    return;
                                }
                                if (writerIndex - readerIndex - 5 < len) {
                                    return;
                                }
                                in.skipBytes(len);
                                continue block6;
                            }
                            case 22: {
                                majorVersion = in.getUnsignedByte(readerIndex + 1);
                                if (majorVersion == 3) {
                                    packetLength = in.getUnsignedShort(readerIndex + 3) + 5;
                                    if (readableBytes < packetLength) {
                                        return;
                                    }
                                    endOffset = readerIndex + packetLength;
                                    offset = readerIndex + 43;
                                    if (endOffset - offset < 6) break block18;
                                    sessionIdLength = in.getUnsignedByte(offset);
                                    cipherSuitesLength = in.getUnsignedShort(offset += sessionIdLength + 1);
                                    compressionMethodLength = in.getUnsignedByte(offset += cipherSuitesLength + 2);
                                    offset += compressionMethodLength + 1;
                                    ** if ((extensionsLimit = (offset += 2) + (extensionsLength = in.getUnsignedShort((int)offset))) > endOffset) goto lbl56
                                    while (extensionsLimit - offset >= 4) {
                                        extensionType = in.getUnsignedShort(offset);
                                        offset += 2;
                                        if (extensionsLimit - (offset += 2) < (extensionLength = in.getUnsignedShort(offset))) break block18;
                                        if (extensionType == 0) {
                                            if (extensionsLimit - (offset += 2) >= 3) {
                                                serverNameType = in.getUnsignedByte(offset);
                                                ++offset;
                                                if (serverNameType == 0 && extensionsLimit - (offset += 2) >= (serverNameLength = in.getUnsignedShort(offset))) {
                                                    hostname = in.toString(offset, serverNameLength, CharsetUtil.UTF_8);
                                                    this.select(ctx, IDN.toASCII(hostname, 1).toLowerCase(Locale.US));
                                                    return;
                                                }
                                            }
                                            break block18;
                                        }
                                        offset += extensionLength;
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
lbl56:
                                    // 2 sources

                                    break block18;
                                }
                            }
                            default: {
                                break block18;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (!SniHandler.logger.isDebugEnabled()) break block18;
                    SniHandler.logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(in), e);
                }
            }
            this.select(ctx, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void select(final ChannelHandlerContext ctx, final String hostname) {
        Future<SslContext> future = this.mapping.map(hostname, ctx.executor().newPromise());
        if (future.isDone()) {
            if (!future.isSuccess()) throw new DecoderException("failed to get the SslContext for " + hostname, future.cause());
            this.replaceHandler(ctx, new Selection(future.getNow(), hostname));
            return;
        } else {
            this.suppressRead = true;
            future.addListener((GenericFutureListener<Future<SslContext>>)new FutureListener<SslContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(Future<SslContext> future) throws Exception {
                    try {
                        SniHandler.this.suppressRead = false;
                        if (future.isSuccess()) {
                            SniHandler.this.replaceHandler(ctx, new Selection(future.getNow(), hostname));
                        } else {
                            ctx.fireExceptionCaught(new DecoderException("failed to get the SslContext for " + hostname, future.cause()));
                        }
                    }
                    finally {
                        if (SniHandler.this.readPending) {
                            SniHandler.this.readPending = false;
                            ctx.read();
                        }
                    }
                }
            });
        }
    }

    private void replaceHandler(ChannelHandlerContext ctx, Selection selection) {
        this.selection = selection;
        SslHandler sslHandler = selection.context.newHandler(ctx.alloc());
        ctx.pipeline().replace(this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            ctx.read();
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    private static final class Selection {
        final SslContext context;
        final String hostname;

        Selection(SslContext context, String hostname) {
            this.context = context;
            this.hostname = hostname;
        }
    }

    private static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            this.mapping = ObjectUtil.checkNotNull(mapping, "mapping");
        }

        @Override
        public Future<SslContext> map(String input, Promise<SslContext> promise) {
            SslContext context;
            try {
                context = this.mapping.map(input);
            }
            catch (Throwable cause) {
                return promise.setFailure(cause);
            }
            return promise.setSuccess(context);
        }
    }
}

