/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.com.google.common.io.BaseEncoding;

public class HttpWaitStrategy
extends GenericContainer.AbstractWaitStrategy {
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTH_BASIC = "Basic ";
    private String path = "/";
    private int statusCode = 200;
    private boolean tlsEnabled;
    private String username;
    private String password;

    public HttpWaitStrategy forStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HttpWaitStrategy forPath(String path) {
        this.path = path;
        return this;
    }

    public HttpWaitStrategy usingTls() {
        this.tlsEnabled = true;
        return this;
    }

    public HttpWaitStrategy withBasicCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    @Override
    protected void waitUntilReady() {
        Integer livenessCheckPort = this.getLivenessCheckPort();
        if (null == livenessCheckPort) {
            this.logger().warn("No exposed ports or mapped ports - cannot wait for status");
            return;
        }
        String uri = this.buildLivenessUri(livenessCheckPort).toString();
        this.logger().info("Waiting for {} seconds for URL: {}", (Object)this.startupTimeout.getSeconds(), (Object)uri);
        try {
            Unreliables.retryUntilSuccess((int)this.startupTimeout.getSeconds(), TimeUnit.SECONDS, () -> {
                this.getRateLimiter().doWhenReady(() -> {
                    try {
                        HttpURLConnection connection = (HttpURLConnection)new URL(uri).openConnection();
                        if (!Strings.isNullOrEmpty(this.username)) {
                            connection.setRequestProperty(HEADER_AUTHORIZATION, this.buildAuthString(this.username, this.password));
                            connection.setUseCaches(false);
                        }
                        connection.setRequestMethod("GET");
                        connection.connect();
                        if (this.statusCode != connection.getResponseCode()) {
                            throw new RuntimeException(String.format("HTTP response code was: %s", connection.getResponseCode()));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                return true;
            });
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException(String.format("Timed out waiting for URL to be accessible (%s should return HTTP %s)", uri, this.statusCode));
        }
    }

    private URI buildLivenessUri(int livenessCheckPort) {
        String scheme = (this.tlsEnabled ? "https" : "http") + "://";
        String host = this.container.getContainerIpAddress();
        String portSuffix = this.tlsEnabled && 443 == livenessCheckPort || !this.tlsEnabled && 80 == livenessCheckPort ? "" : ":" + String.valueOf(livenessCheckPort);
        return URI.create(scheme + host + portSuffix + this.path);
    }

    private String buildAuthString(String username, String password) {
        return AUTH_BASIC + BaseEncoding.base64().encode((username + ":" + password).getBytes());
    }
}

