/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.traits.VncService;
import org.testcontainers.utility.TestcontainersConfiguration;

public class VncRecordingSidekickContainer<SELF extends VncRecordingSidekickContainer<SELF, T>, T extends VncService & LinkableContainer>
extends GenericContainer<SELF> {
    private final T vncServiceContainer;
    private final Path tempDir;

    public VncRecordingSidekickContainer(T vncServiceContainer) {
        super(TestcontainersConfiguration.getInstance().getVncRecordedContainerImage());
        this.vncServiceContainer = vncServiceContainer;
        try {
            this.tempDir = this.createVolumeDirectory(true);
            Path passwordFile = this.tempDir.resolve("password");
            Files.write(passwordFile, vncServiceContainer.getPassword().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void containerIsStarting(InspectContainerResponse containerInfo) {
    }

    @Override
    protected Integer getLivenessCheckPort() {
        return null;
    }

    @Override
    protected void configure() {
        this.addFileSystemBind(this.tempDir.toAbsolutePath().toString(), "/recording", BindMode.READ_WRITE);
        this.addLink((LinkableContainer)this.vncServiceContainer, "vnchost");
        this.setCommand("-o", "/recording/screen.flv", "-P", "/recording/password", "vnchost", String.valueOf(this.vncServiceContainer.getPort()));
    }

    public Path getRecordingPath() {
        return this.tempDir.resolve("screen.flv");
    }

    public void stopAndRetainRecording(File destination) {
        super.stop();
        try {
            Files.move(this.getRecordingPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not move recording file from " + this.getRecordingPath() + " to " + destination, e);
        }
    }
}

