/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Container;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.AmbassadorContainer;
import org.testcontainers.containers.ContainerisedDockerCompose;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.FutureContainer;
import org.testcontainers.containers.LocalDockerCompose;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.LogUtils;
import org.testcontainers.utility.ResourceReaper;

public class DockerComposeContainer<SELF extends DockerComposeContainer<SELF>>
extends FailureDetectingExternalResource {
    private final String identifier;
    private final Map<String, AmbassadorContainer> ambassadorContainers = new HashMap<String, AmbassadorContainer>();
    private final List<File> composeFiles;
    private Set<String> spawnedContainerIds = Collections.emptySet();
    private Map<String, Integer> scalingPreferences = new HashMap<String, Integer>();
    private DockerClient dockerClient;
    private boolean localCompose;
    private boolean pull = true;
    private boolean tailChildContainers;
    private static final Object MUTEX = new Object();
    private Map<String, String> env = new HashMap<String, String>();
    private static final RateLimiter AMBASSADOR_CREATION_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(6, TimeUnit.MINUTES).withConstantThroughput().build();

    @Deprecated
    public DockerComposeContainer(File composeFile, String identifier) {
        this(identifier, composeFile);
    }

    public DockerComposeContainer(File ... composeFiles) {
        this(Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(List<File> composeFiles) {
        this(Base58.randomString(6).toLowerCase(), composeFiles);
    }

    public DockerComposeContainer(String identifier, File ... composeFiles) {
        this(identifier, Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(String identifier, List<File> composeFiles) {
        this.composeFiles = composeFiles;
        this.identifier = identifier;
        this.dockerClient = DockerClientFactory.instance().client();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void starting(Description description) {
        Profiler profiler = new Profiler("Docker Compose container rule");
        profiler.setLogger(this.logger());
        profiler.start("Docker Compose container startup");
        Object object = MUTEX;
        synchronized (object) {
            if (this.pull) {
                this.pullImages();
            }
            this.applyScaling();
            this.createServices();
            if (this.tailChildContainers) {
                this.tailChildContainerLogs();
            }
            this.registerContainersForShutdown();
            this.startAmbassadorContainers(profiler);
        }
    }

    private void pullImages() {
        this.getDockerCompose("pull").start();
    }

    private void createServices() {
        this.getDockerCompose("up -d").start();
    }

    private void tailChildContainerLogs() {
        this.listChildContainers().forEach(container -> LogUtils.followOutput(this.dockerClient, container.getId(), new Slf4jLogConsumer(this.logger()).withPrefix(container.getNames()[0]), OutputFrame.OutputType.STDOUT, OutputFrame.OutputType.STDERR));
    }

    private DockerCompose getDockerCompose(String cmd) {
        DockerCompose dockerCompose = this.localCompose ? new LocalDockerCompose(this.composeFiles, this.identifier) : new ContainerisedDockerCompose(this.composeFiles, this.identifier);
        return dockerCompose.withCommand(cmd).withEnv(this.env);
    }

    private void applyScaling() {
        if (!this.scalingPreferences.isEmpty()) {
            StringBuilder sb = new StringBuilder("scale");
            for (Map.Entry<String, Integer> scale : this.scalingPreferences.entrySet()) {
                sb.append(" ").append(scale.getKey()).append("=").append(scale.getValue());
            }
            this.getDockerCompose(sb.toString()).start();
        }
    }

    private void registerContainersForShutdown() {
        try {
            List<Container> containers = this.listChildContainers();
            containers.forEach(container -> ResourceReaper.instance().registerContainerForCleanup(container.getId(), container.getNames()[0]));
            ResourceReaper.instance().registerNetworkForCleanup(this.identifier + "_default");
            ((List)this.dockerClient.listNetworksCmd().exec()).forEach(network -> {
                if (network.getName().contains(this.identifier)) {
                    ResourceReaper.instance().registerNetworkForCleanup(network.getName());
                }
            });
            this.spawnedContainerIds = containers.stream().map(Container::getId).collect(Collectors.toSet());
        }
        catch (DockerException e) {
            this.logger().debug("Failed to stop a service container with exception", e);
        }
    }

    private List<Container> listChildContainers() {
        return ((List)this.dockerClient.listContainersCmd().withShowAll(true).exec()).stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/" + this.identifier))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAmbassadorContainers(Profiler profiler) {
        for (Map.Entry<String, AmbassadorContainer> address : this.ambassadorContainers.entrySet()) {
            try {
                profiler.start("Ambassador container startup");
                AmbassadorContainer ambassadorContainer = address.getValue();
                Unreliables.retryUntilSuccess(120, TimeUnit.SECONDS, () -> {
                    AMBASSADOR_CREATION_RATE_LIMITER.doWhenReady(() -> {
                        Profiler localProfiler = profiler.startNested("Ambassador container: " + ambassadorContainer.getContainerName());
                        localProfiler.start("Start ambassador container");
                        ambassadorContainer.start();
                    });
                    return null;
                });
            }
            catch (Exception e) {
                this.logger().warn("Exception during ambassador container startup!", e);
            }
            finally {
                profiler.stop().log();
            }
        }
    }

    private Logger logger() {
        return LoggerFactory.getLogger(DockerComposeContainer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void finished(Description description) {
        Object object = MUTEX;
        synchronized (object) {
            this.ambassadorContainers.forEach((address, container) -> container.stop());
            this.getDockerCompose("down -v").start();
            ResourceReaper.instance().removeNetworks(this.identifier);
            this.spawnedContainerIds.forEach(id -> ResourceReaper.instance().stopAndRemoveContainer((String)id));
            this.spawnedContainerIds.clear();
        }
    }

    public SELF withExposedService(String serviceName, int servicePort) {
        if (!serviceName.matches(".*_[0-9]+")) {
            serviceName = serviceName + "_1";
        }
        AmbassadorContainer ambassadorContainer = (AmbassadorContainer)new AmbassadorContainer(new FutureContainer(this.identifier + "_" + serviceName), serviceName, servicePort).withEnv((Map)this.env);
        this.ambassadorContainers.put(serviceName + ":" + servicePort, ambassadorContainer);
        return this.self();
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort) {
        return this.withExposedService(serviceName + "_" + instance, servicePort);
    }

    public String getServiceHost(String serviceName, Integer servicePort) {
        return this.ambassadorContainers.get(serviceName + ":" + servicePort).getContainerIpAddress();
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        return this.ambassadorContainers.get(serviceName + ":" + servicePort).getMappedPort(servicePort);
    }

    public SELF withScaledService(String serviceBaseName, int numInstances) {
        this.scalingPreferences.put(serviceBaseName, numInstances);
        return this.self();
    }

    public SELF withEnv(String key, String value) {
        this.env.put(key, value);
        return this.self();
    }

    public SELF withEnv(Map<String, String> env) {
        env.forEach(this.env::put);
        return this.self();
    }

    public SELF withLocalCompose(boolean localCompose) {
        this.localCompose = localCompose;
        return this.self();
    }

    public SELF withPull(boolean pull) {
        this.pull = pull;
        return this.self();
    }

    public SELF withTailChildContainers(boolean tailChildContainers) {
        this.tailChildContainers = tailChildContainers;
        return this.self();
    }

    private SELF self() {
        return (SELF)this;
    }
}

