/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.github.dockerjava.core.util.FilePathUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.testcontainers.shaded.com.google.common.io.Closeables;

public class TarDirWalker
extends SimpleFileVisitor<Path> {
    private Path basePath;
    private TarArchiveOutputStream tarArchiveOutputStream;

    public TarDirWalker(Path basePath, TarArchiveOutputStream tarArchiveOutputStream) {
        this.basePath = basePath;
        this.tarArchiveOutputStream = tarArchiveOutputStream;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (!dir.equals(this.basePath)) {
            this.tarArchiveOutputStream.putArchiveEntry(new TarArchiveEntry(FilePathUtil.relativize(this.basePath, dir)));
            this.tarArchiveOutputStream.closeArchiveEntry();
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        TarArchiveEntry tarEntry = new TarArchiveEntry(FilePathUtil.relativize(this.basePath, file));
        if (file.toFile().canExecute()) {
            tarEntry.setMode(tarEntry.getMode() | 0x1ED);
        }
        CompressArchiveUtil.putTarEntry(this.tarArchiveOutputStream, tarEntry, file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        Closeables.close(this.tarArchiveOutputStream, true);
        throw exc;
    }
}

