/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.javax.annotation.CheckForNull;

public class PushImageResultCallback
extends ResultCallbackTemplate<PushImageResultCallback, PushResponseItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushImageResultCallback.class);
    @CheckForNull
    private PushResponseItem latestItem = null;

    @Override
    public void onNext(PushResponseItem item) {
        this.latestItem = item;
        LOGGER.debug(item.toString());
    }

    public void awaitSuccess() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("", e);
        }
        if (this.latestItem == null) {
            throw new DockerClientException("Could not push image");
        }
        if (this.latestItem.isErrorIndicated()) {
            throw new DockerClientException("Could not push image: " + this.latestItem.getError());
        }
    }
}

