/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.security.spec.ECGenParameterSpec;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import org.testcontainers.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;

class ECUtils {
    ECUtils() {
    }

    static X9ECParameters getDomainParametersFromGenSpec(ECGenParameterSpec eCGenParameterSpec) {
        return ECUtils.getDomainParametersFromName(eCGenParameterSpec.getName());
    }

    static X9ECParameters getDomainParametersFromName(String string) {
        X9ECParameters x9ECParameters;
        try {
            if (string.charAt(0) >= '0' && string.charAt(0) <= '2') {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
                x9ECParameters = ECUtil.getNamedCurveByOid(aSN1ObjectIdentifier);
            } else if (string.indexOf(32) > 0) {
                string = string.substring(string.indexOf(32) + 1);
                x9ECParameters = ECUtil.getNamedCurveByName(string);
            } else {
                x9ECParameters = ECUtil.getNamedCurveByName(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            x9ECParameters = ECUtil.getNamedCurveByName(string);
        }
        return x9ECParameters;
    }
}

