/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.netty.exec;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.github.dockerjava.api.async.ResultCallback;
import org.testcontainers.shaded.com.github.dockerjava.api.command.EventsCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Event;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersEncoder;
import org.testcontainers.shaded.com.github.dockerjava.netty.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.AbstrAsyncDockerCmdExec;
import org.testcontainers.shaded.com.google.common.net.UrlEscapers;

public class EventsCmdExec
extends AbstrAsyncDockerCmdExec<EventsCmd, Event>
implements EventsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsCmdExec.class);

    public EventsCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected Void execute0(EventsCmd command, ResultCallback<Event> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/events").queryParam("since", command.getSince()).queryParam("until", command.getUntil());
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        webTarget.request().get(new TypeReference<Event>(){}, resultCallback);
        return null;
    }
}

