/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Security;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.testcontainers.shaded.com.github.dockerjava.api.command.AttachContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.AuthCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.BuildImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CommitCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ConnectToNetworkCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ContainerDiffCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateNetworkCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateVolumeCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.DockerCmdExecFactory;
import org.testcontainers.shaded.com.github.dockerjava.api.command.EventsCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ExecCreateCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ExecStartCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InfoCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectExecCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectNetworkCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectVolumeCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.KillContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ListContainersCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ListImagesCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ListNetworksCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ListVolumesCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.LoadImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.LogContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.PauseContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.PingCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.PullImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.PushImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.RemoveContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.RemoveImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.RemoveNetworkCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.RemoveVolumeCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.RenameContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.RestartContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.SaveImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.SearchImagesCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.StartContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.StatsCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.StopContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.TagImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.TopContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.UnpauseContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.UpdateContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.VersionCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.WaitContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.SSLConfig;
import org.testcontainers.shaded.com.github.dockerjava.netty.ChannelProvider;
import org.testcontainers.shaded.com.github.dockerjava.netty.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.AttachContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.AuthCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.BuildImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CommitCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ConnectToNetworkCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ContainerDiffCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CopyArchiveFromContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CopyArchiveToContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CopyFileFromContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CreateContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CreateImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CreateNetworkCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.CreateVolumeCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.DisconnectFromNetworkCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.EventsCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ExecCreateCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ExecStartCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.InfoCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.InspectContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.InspectExecCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.InspectImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.InspectNetworkCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.InspectVolumeCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.KillContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ListContainersCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ListImagesCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ListNetworksCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.ListVolumesCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.LoadImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.LogContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.PauseContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.PingCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.PullImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.PushImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.RemoveContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.RemoveImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.RemoveNetworkCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.RemoveVolumeCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.RenameContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.RestartContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.SaveImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.SearchImagesCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.StartContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.StatsCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.StopContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.TagImageCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.TopContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.UnpauseContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.UpdateContainerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.VersionCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.WaitContainerCmdExec;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.io.netty.bootstrap.Bootstrap;
import org.testcontainers.shaded.io.netty.channel.Channel;
import org.testcontainers.shaded.io.netty.channel.ChannelConfig;
import org.testcontainers.shaded.io.netty.channel.ChannelFactory;
import org.testcontainers.shaded.io.netty.channel.ChannelInitializer;
import org.testcontainers.shaded.io.netty.channel.EventLoopGroup;
import org.testcontainers.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.testcontainers.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.testcontainers.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.testcontainers.shaded.io.netty.channel.socket.DuplexChannel;
import org.testcontainers.shaded.io.netty.channel.socket.SocketChannel;
import org.testcontainers.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.testcontainers.shaded.io.netty.channel.unix.DomainSocketAddress;
import org.testcontainers.shaded.io.netty.channel.unix.UnixChannel;
import org.testcontainers.shaded.io.netty.handler.codec.http.HttpClientCodec;
import org.testcontainers.shaded.io.netty.handler.logging.LoggingHandler;
import org.testcontainers.shaded.io.netty.handler.ssl.SslHandler;
import org.testcontainers.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.testcontainers.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;

public class NettyDockerCmdExecFactory
implements DockerCmdExecFactory {
    private static String threadPrefix = "dockerjava-netty";
    private DockerClientConfig dockerClientConfig;
    private Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private NettyInitializer nettyInitializer;
    private ChannelProvider channelProvider = new ChannelProvider(){

        @Override
        public DuplexChannel getChannel() {
            DuplexChannel channel = NettyDockerCmdExecFactory.this.connect();
            channel.pipeline().addLast(new LoggingHandler(this.getClass()));
            return channel;
        }
    };
    private Integer connectTimeout = null;

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        this.dockerClientConfig = dockerClientConfig;
        this.bootstrap = new Bootstrap();
        String scheme = dockerClientConfig.getDockerHost().getScheme();
        if ("unix".equals(scheme)) {
            this.nettyInitializer = new UnixDomainSocketInitializer();
        } else if ("tcp".equals(scheme)) {
            this.nettyInitializer = new InetSocketInitializer();
        }
        this.eventLoopGroup = this.nettyInitializer.init(this.bootstrap, dockerClientConfig);
    }

    private DuplexChannel connect() {
        try {
            return this.connect(this.bootstrap);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
        return this.nettyInitializer.connect(bootstrap);
    }

    protected DockerClientConfig getDockerClientConfig() {
        Preconditions.checkNotNull(this.dockerClientConfig, "Factor not initialized, dockerClientConfig not set. You probably forgot to call init()!");
        return this.dockerClientConfig;
    }

    public SSLParameters enableHostNameVerification(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sslParameters;
    }

    @Override
    public CopyArchiveFromContainerCmd.Exec createCopyArchiveFromContainerCmdExec() {
        return new CopyArchiveFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyArchiveToContainerCmd.Exec createCopyArchiveToContainerCmdExec() {
        return new CopyArchiveToContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public AuthCmd.Exec createAuthCmdExec() {
        return new AuthCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InfoCmd.Exec createInfoCmdExec() {
        return new InfoCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PingCmd.Exec createPingCmdExec() {
        return new PingCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public VersionCmd.Exec createVersionCmdExec() {
        return new VersionCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PullImageCmd.Exec createPullImageCmdExec() {
        return new PullImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PushImageCmd.Exec createPushImageCmdExec() {
        return new PushImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SaveImageCmd.Exec createSaveImageCmdExec() {
        return new SaveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public LoadImageCmd.Exec createLoadImageCmdExec() {
        return new LoadImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return new SearchImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListImagesCmd.Exec createListImagesCmdExec() {
        return new ListImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return new InspectImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListContainersCmd.Exec createListContainersCmdExec() {
        return new ListContainersCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new StartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return new InspectContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecCreateCmd.Exec createExecCmdExec() {
        return new ExecCreateCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return new WaitContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return new AttachContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecStartCmd.Exec createExecStartCmdExec() {
        return new ExecStartCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectExecCmd.Exec createInspectExecCmdExec() {
        return new InspectExecCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return new LogContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return new CopyFileFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return new StopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return new ContainerDiffCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return new KillContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UpdateContainerCmd.Exec createUpdateContainerCmdExec() {
        return new UpdateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RenameContainerCmd.Exec createRenameContainerCmdExec() {
        return new RenameContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return new RestartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CommitCmd.Exec createCommitCmdExec() {
        return new CommitCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return new TopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TagImageCmd.Exec createTagImageCmdExec() {
        return new TagImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return new PauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return new UnpauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public EventsCmd.Exec createEventsCmdExec() {
        return new EventsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StatsCmd.Exec createStatsCmdExec() {
        return new StatsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateVolumeCmd.Exec createCreateVolumeCmdExec() {
        return new CreateVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectVolumeCmd.Exec createInspectVolumeCmdExec() {
        return new InspectVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveVolumeCmd.Exec createRemoveVolumeCmdExec() {
        return new RemoveVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListVolumesCmd.Exec createListVolumesCmdExec() {
        return new ListVolumesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListNetworksCmd.Exec createListNetworksCmdExec() {
        return new ListNetworksCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectNetworkCmd.Exec createInspectNetworkCmdExec() {
        return new InspectNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateNetworkCmd.Exec createCreateNetworkCmdExec() {
        return new CreateNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveNetworkCmd.Exec createRemoveNetworkCmdExec() {
        return new RemoveNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ConnectToNetworkCmd.Exec createConnectToNetworkCmdExec() {
        return new ConnectToNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public DisconnectFromNetworkCmd.Exec createDisconnectFromNetworkCmdExec() {
        return new DisconnectFromNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull(this.eventLoopGroup, "Factory not initialized. You probably forgot to call init()!");
        this.eventLoopGroup.shutdownGracefully();
    }

    public NettyDockerCmdExecFactory withConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    private <T extends Channel> T configure(T channel) {
        ChannelConfig channelConfig = channel.config();
        if (this.connectTimeout != null) {
            channelConfig.setConnectTimeoutMillis(this.connectTimeout);
        }
        return channel;
    }

    private WebTarget getBaseResource() {
        return new WebTarget(this.channelProvider);
    }

    private class InetSocketInitializer
    implements NettyInitializer {
        private InetSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            InetAddress addr = InetAddress.getLoopbackAddress();
            InetSocketAddress proxyAddress = new InetSocketAddress(addr, 8008);
            Security.addProvider(new BouncyCastleProvider());
            ChannelFactory<NioSocketChannel> factory = new ChannelFactory<NioSocketChannel>(){

                @Override
                public NioSocketChannel newChannel() {
                    return (NioSocketChannel)NettyDockerCmdExecFactory.this.configure(new NioSocketChannel());
                }
            };
            ((Bootstrap)((Bootstrap)bootstrap.group(nioEventLoopGroup)).channelFactory(factory)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new HttpClientCodec());
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            String host = NettyDockerCmdExecFactory.this.dockerClientConfig.getDockerHost().getHost();
            int port = NettyDockerCmdExecFactory.this.dockerClientConfig.getDockerHost().getPort();
            if (port == -1) {
                throw new RuntimeException("no port configured for " + host);
            }
            DuplexChannel channel = (DuplexChannel)bootstrap.connect(host, port).sync().channel();
            SslHandler ssl = this.initSsl(NettyDockerCmdExecFactory.this.dockerClientConfig);
            if (ssl != null) {
                channel.pipeline().addFirst(ssl);
            }
            return channel;
        }

        private SslHandler initSsl(DockerClientConfig dockerClientConfig) {
            SslHandler ssl = null;
            try {
                String host = dockerClientConfig.getDockerHost().getHost();
                int port = dockerClientConfig.getDockerHost().getPort();
                SSLConfig sslConfig = dockerClientConfig.getSSLConfig();
                if (sslConfig != null && sslConfig.getSSLContext() != null) {
                    SSLEngine engine = sslConfig.getSSLContext().createSSLEngine(host, port);
                    engine.setUseClientMode(true);
                    engine.setSSLParameters(NettyDockerCmdExecFactory.this.enableHostNameVerification(engine.getSSLParameters()));
                    ssl = new SslHandler(engine);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ssl;
        }
    }

    private class UnixDomainSocketInitializer
    implements NettyInitializer {
        private UnixDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(0, new DefaultThreadFactory(threadPrefix));
            ChannelFactory<EpollDomainSocketChannel> factory = new ChannelFactory<EpollDomainSocketChannel>(){

                @Override
                public EpollDomainSocketChannel newChannel() {
                    return (EpollDomainSocketChannel)NettyDockerCmdExecFactory.this.configure(new EpollDomainSocketChannel());
                }
            };
            ((Bootstrap)((Bootstrap)bootstrap.group(epollEventLoopGroup)).channelFactory(factory)).handler(new ChannelInitializer<UnixChannel>(){

                @Override
                protected void initChannel(UnixChannel channel) throws Exception {
                    channel.pipeline().addLast(new HttpClientCodec());
                }
            });
            return epollEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            return (DuplexChannel)bootstrap.connect(new DomainSocketAddress("/var/run/docker.sock")).sync().channel();
        }
    }

    private static interface NettyInitializer {
        public EventLoopGroup init(Bootstrap var1, DockerClientConfig var2);

        public DuplexChannel connect(Bootstrap var1) throws InterruptedException;
    }
}

