/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FiltersBuilder {
    private Map<String, List<String>> filters = new HashMap<String, List<String>>();

    public FiltersBuilder withFilter(String key, String ... value) {
        this.filters.put(key, Arrays.asList(value));
        return this;
    }

    public List<String> getFilter(String key) {
        return this.filters.get(key);
    }

    public FiltersBuilder withImages(String ... image) {
        this.withFilter("image", image);
        return this;
    }

    public List<String> getImage() {
        return this.getFilter("image");
    }

    public FiltersBuilder withContainers(String ... container) {
        this.withFilter("container", container);
        return this;
    }

    public List<String> getContainer() {
        return this.getFilter("container");
    }

    public FiltersBuilder withLabels(String ... labels) {
        this.withFilter("label", labels);
        return this;
    }

    public FiltersBuilder withLabels(Map<String, String> labels) {
        this.withFilter("label", FiltersBuilder.labelsMapToList(labels).toArray(new String[labels.size()]));
        return this;
    }

    private static List<String> labelsMapToList(Map<String, String> labels) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            String rest = entry.getValue() != null & !entry.getValue().isEmpty() ? "=" + entry.getValue() : "";
            String label = entry.getKey() + rest;
            result.add(label);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiltersBuilder filters1 = (FiltersBuilder)o;
        return this.filters.equals(filters1.filters);
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public Map<String, List<String>> build() {
        return this.filters;
    }
}

