/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import java.util.List;
import java.util.Map;
import org.testcontainers.shaded.com.github.dockerjava.api.command.EventsCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Event;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersBuilder;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class EventsCmdImpl
extends AbstrAsyncDockerCmd<EventsCmd, Event>
implements EventsCmd {
    private String since;
    private String until;
    private FiltersBuilder filters = new FiltersBuilder();

    public EventsCmdImpl(EventsCmd.Exec exec) {
        super(exec);
    }

    @Override
    public EventsCmd withSince(String since) {
        this.since = since;
        return this;
    }

    @Override
    public EventsCmd withUntil(String until) {
        this.until = until;
        return this;
    }

    @Override
    public EventsCmd withContainerFilter(String ... container) {
        Preconditions.checkNotNull(container, "container have not been specified");
        this.filters.withContainers(container);
        return this;
    }

    @Override
    public EventsCmd withImageFilter(String ... image) {
        Preconditions.checkNotNull(image, "image have not been specified");
        this.filters.withImages(image);
        return this;
    }

    @Override
    public EventsCmd withEventFilter(String ... event) {
        Preconditions.checkNotNull(event, "event have not been specified");
        this.filters.withFilter("event", event);
        return this;
    }

    @Override
    public EventsCmd withLabelFilter(String ... label) {
        Preconditions.checkNotNull(label, "label have not been specified");
        this.filters.withLabels(label);
        return this;
    }

    @Override
    public EventsCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public String getUntil() {
        return this.until;
    }

    @Override
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }
}

