/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.github.dockerjava.api.command.DockerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.DockerCmdSyncExec;
import org.testcontainers.shaded.com.github.dockerjava.api.command.SyncDockerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.AuthConfig;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public abstract class AbstrDockerCmd<CMD_T extends DockerCmd<RES_T>, RES_T>
implements SyncDockerCmd<RES_T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstrDockerCmd.class);
    protected DockerCmdSyncExec<CMD_T, RES_T> execution;

    public AbstrDockerCmd(DockerCmdSyncExec<CMD_T, RES_T> execution) {
        Preconditions.checkNotNull(execution, "execution was not specified");
        this.execution = execution;
    }

    @Override
    public RES_T exec() throws DockerException {
        LOGGER.debug("Cmd: {}", (Object)this);
        return this.execution.exec(this);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SIMPLE_STYLE);
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String(new ObjectMapper().writeValueAsString(authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

