/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.async;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.api.async.ResultCallback;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.javax.annotation.CheckForNull;

public abstract class ResultCallbackTemplate<RC_T extends ResultCallback<A_RES_T>, A_RES_T>
implements ResultCallback<A_RES_T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultCallbackTemplate.class);
    private final CountDownLatch started = new CountDownLatch(1);
    private final CountDownLatch completed = new CountDownLatch(1);
    private Closeable stream;
    private boolean closed = false;
    private Throwable firstError = null;

    @Override
    public void onStart(Closeable stream) {
        this.stream = stream;
        this.closed = false;
        this.started.countDown();
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.closed) {
            return;
        }
        if (this.firstError == null) {
            this.firstError = throwable;
        }
        try {
            LOGGER.error("Error during callback", throwable);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onComplete() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.stream != null) {
                this.stream.close();
            }
            this.completed.countDown();
        }
    }

    public RC_T awaitCompletion() throws InterruptedException {
        this.completed.await();
        this.getFirstError();
        return (RC_T)this;
    }

    public boolean awaitCompletion(long timeout, TimeUnit timeUnit) throws InterruptedException {
        boolean result = this.completed.await(timeout, timeUnit);
        this.getFirstError();
        return result;
    }

    public RC_T awaitStarted() throws InterruptedException {
        this.started.await();
        return (RC_T)this;
    }

    public boolean awaitStarted(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.started.await(timeout, timeUnit);
    }

    @CheckForNull
    protected RuntimeException getFirstError() {
        if (this.firstError != null) {
            return Throwables.propagate(this.firstError);
        }
        return null;
    }
}

