/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientConfigUtils;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientBuilder;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import org.testcontainers.shaded.com.google.common.base.Throwables;

public abstract class DockerClientProviderStrategy {
    protected DockerClient client;
    protected DockerClientConfig config;
    private static final RateLimiter PING_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(2, TimeUnit.SECONDS).withConstantThroughput().build();
    protected static final Logger LOGGER = LoggerFactory.getLogger(DockerClientProviderStrategy.class);

    public abstract void test() throws InvalidConfigurationException;

    public abstract String getDescription();

    public static DockerClientProviderStrategy getFirstValidStrategy(List<DockerClientProviderStrategy> strategies) {
        ArrayList<String> configurationFailures = new ArrayList<String>();
        for (DockerClientProviderStrategy strategy : strategies) {
            try {
                strategy.test();
                LOGGER.info("Looking for Docker environment. Tried {}", (Object)strategy.getDescription());
                return strategy;
            }
            catch (Exception | ExceptionInInitializerError | NoClassDefFoundError e) {
                String throwableMessage = e.getMessage();
                Throwable rootCause = Throwables.getRootCause(e);
                String rootCauseMessage = rootCause.getMessage();
                String failureDescription = throwableMessage != null && throwableMessage.equals(rootCauseMessage) ? String.format("%s: failed with exception %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage) : String.format("%s: failed with exception %s (%s). Root cause %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage, rootCause.getClass().getSimpleName(), rootCauseMessage);
                configurationFailures.add(failureDescription);
                LOGGER.debug(failureDescription);
            }
        }
        LOGGER.error("Could not find a valid Docker environment. Please check configuration. Attempted configurations were:");
        for (String failureMessage : configurationFailures) {
            LOGGER.error("    " + failureMessage);
        }
        LOGGER.error("As no valid configuration was found, execution cannot continue");
        throw new IllegalStateException("Could not find a valid Docker environment. Please see logs and check configuration");
    }

    public DockerClient getClient() {
        return this.client;
    }

    protected DockerClient getClientForConfig(DockerClientConfig config) {
        return DockerClientBuilder.getInstance(config).withDockerCmdExecFactory(new NettyDockerCmdExecFactory()).build();
    }

    protected void ping(DockerClient client, int timeoutInSeconds) {
        Unreliables.retryUntilSuccess(timeoutInSeconds, TimeUnit.SECONDS, () -> PING_RATE_LIMITER.getWhenReady(() -> {
            LOGGER.debug("Pinging docker daemon...");
            client.pingCmd().exec();
            return true;
        }));
    }

    public String getDockerHostIpAddress() {
        return DockerClientConfigUtils.getDockerHostIpAddress(this.config);
    }

    class InvalidConfigurationException
    extends RuntimeException {
        public InvalidConfigurationException(String s) {
            super(s);
        }

        public InvalidConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

