/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class TagImageCmdImpl
extends AbstrDockerCmd<TagImageCmd, Void>
implements TagImageCmd {
    private String imageId;
    private String repository;
    private String tag;
    private Boolean force;

    public TagImageCmdImpl(TagImageCmd.Exec exec, String imageId, String repository, String tag) {
        super(exec);
        this.withImageId(imageId);
        this.withRepository(repository);
        this.withTag(tag);
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public Boolean hasForceEnabled() {
        return this.force;
    }

    @Override
    public TagImageCmd withImageId(String imageId) {
        Preconditions.checkNotNull(imageId, "imageId was not specified");
        this.imageId = imageId;
        return this;
    }

    @Override
    public TagImageCmd withRepository(String repository) {
        Preconditions.checkNotNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    @Override
    public TagImageCmd withTag(String tag) {
        Preconditions.checkNotNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    public TagImageCmd withForce() {
        return this.withForce(true);
    }

    @Override
    public TagImageCmd withForce(Boolean force) {
        this.force = force;
        return this;
    }
}

