/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Security;
import javax.net.ssl.SSLContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.org.glassfish.jersey.SslConfigurator;

public class LocalDirectorySSLConfig
implements SSLConfig,
Serializable {
    private static final long serialVersionUID = -4736328026418377358L;
    private final String dockerCertPath;

    public LocalDirectorySSLConfig(String dockerCertPath) {
        Preconditions.checkNotNull(dockerCertPath);
        this.dockerCertPath = dockerCertPath;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    @Override
    public SSLContext getSSLContext() {
        boolean certificatesExist = CertificateUtils.verifyCertificatesExist(this.dockerCertPath);
        if (certificatesExist) {
            try {
                Security.addProvider(new BouncyCastleProvider());
                String httpProtocols = System.getProperty("https.protocols");
                System.setProperty("https.protocols", "TLSv1");
                SslConfigurator sslConfig = SslConfigurator.newInstance(true);
                if (httpProtocols != null) {
                    System.setProperty("https.protocols", httpProtocols);
                }
                String caPemPath = this.dockerCertPath + File.separator + "ca.pem";
                String keyPemPath = this.dockerCertPath + File.separator + "key.pem";
                String certPemPath = this.dockerCertPath + File.separator + "cert.pem";
                String keypem = new String(Files.readAllBytes(Paths.get(keyPemPath, new String[0])));
                String certpem = new String(Files.readAllBytes(Paths.get(certPemPath, new String[0])));
                String capem = new String(Files.readAllBytes(Paths.get(caPemPath, new String[0])));
                sslConfig.keyStore(CertificateUtils.createKeyStore(keypem, certpem));
                sslConfig.keyStorePassword("docker");
                sslConfig.trustStore(CertificateUtils.createTrustStore(capem));
                return sslConfig.createSSLContext();
            }
            catch (Exception e) {
                throw new DockerClientException(e.getMessage(), e);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDirectorySSLConfig that = (LocalDirectorySSLConfig)o;
        return this.dockerCertPath.equals(that.dockerCertPath);
    }

    public int hashCode() {
        return this.dockerCertPath.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "dockerCertPath=" + this.dockerCertPath + "}";
    }
}

