/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.IOUtilDelegator;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.Validate;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io.StreamErrorHandler;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io.StreamTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    private static final Logger log = Logger.getLogger(IOUtil.class.getName());
    private static final StreamErrorHandler DEFAULT_ERROR_HANDLER = new StreamErrorHandler(){

        public void handle(Throwable t) {
            throw new RuntimeException(t);
        }
    };
    private static final String CHARSET_UTF8 = "UTF-8";

    private IOUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless class");
    }

    public static byte[] asByteArray(InputStream in) throws IllegalArgumentException {
        return IOUtilDelegator.asByteArray(in);
    }

    public static String asUTF8String(InputStream in) {
        Validate.notNull(in, "Stream must be specified");
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET_UTF8));
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append(13);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtaining string from " + in, ioe);
        }
        finally {
            block11: {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block11;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
        return buffer.toString();
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
        output.flush();
    }

    public static int copy(InputStream input, OutputStream output, int len) throws IOException {
        byte[] buffer = new byte[len];
        int read = input.read(buffer);
        if (read == -1) {
            return read;
        }
        output.write(buffer, 0, read);
        output.flush();
        return read;
    }

    public static void bufferedWriteWithFlush(OutputStream output, byte[] content) throws IOException {
        int size = 4096;
        int offset = 0;
        while (content.length - offset > 4096) {
            output.write(content, offset, 4096);
            offset += 4096;
        }
        output.write(content, offset, content.length - offset);
        output.flush();
    }

    public static void copyWithClose(InputStream input, OutputStream output) throws IOException {
        try {
            IOUtil.copy(input, output);
        }
        finally {
            block13: {
                block12: {
                    try {
                        input.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block12;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
                try {
                    output.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block13;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
    }

    public static <S extends Closeable> void closeOnComplete(S stream, StreamTask<S> task) {
        IOUtil.closeOnComplete(stream, task, DEFAULT_ERROR_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Closeable> void closeOnComplete(S stream, StreamTask<S> task, StreamErrorHandler errorHandler) {
        try {
            task.execute(stream);
        }
        catch (Throwable t) {
            errorHandler.handle(t);
        }
        finally {
            block13: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block13;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
            }
        }
    }
}

